package org.wildfly.swarm.config.remoting;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
/**
 * Remoting outbound connection with an implicit remote:// URI scheme.
 */
@ResourceType("remote-outbound-connection")
public class RemoteOutboundConnection {

	private String key;
	private String outboundSocketBindingRef;
	private String protocol;
	private String securityRealm;
	private String username;
	private RemoteOutboundConnectionResources subresources = new RemoteOutboundConnectionResources();

	public RemoteOutboundConnection(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Name of the outbound-socket-binding which will be used to determine the destination address and port for the connection.
	 */
	@ModelNodeBinding(detypedName = "outbound-socket-binding-ref")
	public String outboundSocketBindingRef() {
		return this.outboundSocketBindingRef;
	}

	/**
	 * Name of the outbound-socket-binding which will be used to determine the destination address and port for the connection.
	 */
	@SuppressWarnings("unchecked")
	public RemoteOutboundConnection outboundSocketBindingRef(String value) {
		this.outboundSocketBindingRef = value;
		return (RemoteOutboundConnection) this;
	}

	/**
	 * The protocol to use for the remote connection. Defaults to http-remoting.
	 */
	@ModelNodeBinding(detypedName = "protocol")
	public String protocol() {
		return this.protocol;
	}

	/**
	 * The protocol to use for the remote connection. Defaults to http-remoting.
	 */
	@SuppressWarnings("unchecked")
	public RemoteOutboundConnection protocol(String value) {
		this.protocol = value;
		return (RemoteOutboundConnection) this;
	}

	/**
	 * Reference to the security realm to use to obtain the password and SSL configuration.
	 */
	@ModelNodeBinding(detypedName = "security-realm")
	public String securityRealm() {
		return this.securityRealm;
	}

	/**
	 * Reference to the security realm to use to obtain the password and SSL configuration.
	 */
	@SuppressWarnings("unchecked")
	public RemoteOutboundConnection securityRealm(String value) {
		this.securityRealm = value;
		return (RemoteOutboundConnection) this;
	}

	/**
	 * The user name to use when authenticating against the remote server.
	 */
	@ModelNodeBinding(detypedName = "username")
	public String username() {
		return this.username;
	}

	/**
	 * The user name to use when authenticating against the remote server.
	 */
	@SuppressWarnings("unchecked")
	public RemoteOutboundConnection username(String value) {
		this.username = value;
		return (RemoteOutboundConnection) this;
	}

	public RemoteOutboundConnectionResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.remoting.Property objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.remoting.Property objects.
	 */
	@SuppressWarnings("unchecked")
	public RemoteOutboundConnection propertys(
			List<org.wildfly.swarm.config.remoting.Property> value) {
		this.subresources.propertys.addAll(value);
		return (RemoteOutboundConnection) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.remoting.Property object to the list of subresources
	 * @param value The org.wildfly.swarm.config.remoting.Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public RemoteOutboundConnection property(Property value) {
		this.subresources.propertys.add(value);
		return (RemoteOutboundConnection) this;
	}

	/**
	 * Child mutators for RemoteOutboundConnection
	 */
	public class RemoteOutboundConnectionResources {
		/**
		 * Properties supported by the underlying provider. The property name is inferred from the last element of the properties address.
		 */
		private List<org.wildfly.swarm.config.remoting.Property> propertys = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.remoting.Property resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> propertys() {
			return this.propertys;
		}
	}
}