package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.audit.ProviderModule;
/**
 * Auditing configuration. Configures a list of provider modules to be used.
 */
@ResourceType("audit")
@Implicit
public class ClassicAudit {

	private String key;
	private ClassicAuditResources subresources = new ClassicAuditResources();

	public ClassicAudit() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	public ClassicAuditResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.security.security_domain.audit.ProviderModule objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.security.security_domain.audit.ProviderModule objects.
	 */
	@SuppressWarnings("unchecked")
	public ClassicAudit providerModules(
			List<org.wildfly.swarm.config.security.security_domain.audit.ProviderModule> value) {
		this.subresources.providerModules.addAll(value);
		return (ClassicAudit) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.security.security_domain.audit.ProviderModule object to the list of subresources
	 * @param value The org.wildfly.swarm.config.security.security_domain.audit.ProviderModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicAudit providerModule(ProviderModule value) {
		this.subresources.providerModules.add(value);
		return (ClassicAudit) this;
	}

	/**
	 * Child mutators for ClassicAudit
	 */
	public class ClassicAuditResources {
		/**
		 * List of modules that map principal, role, and credential information
		 */
		private List<org.wildfly.swarm.config.security.security_domain.audit.ProviderModule> providerModules = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.security.security_domain.audit.ProviderModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ProviderModule> providerModules() {
			return this.providerModules;
		}
	}
}