package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * JSSE configuration. Configures attributes for keystores that can be used for setting up SSL.
 */
@ResourceType("jsse")
@Implicit
public class ClassicJsse {

	private String key;
	private Map additionalProperties;
	private String cipherSuites;
	private String clientAlias;
	private Boolean clientAuth;
	private Map keyManager;
	private Map keystore;
	private String protocols;
	private String serverAlias;
	private String serviceAuthToken;
	private Map trustManager;
	private Map truststore;

	public ClassicJsse() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Additional properties that may be necessary to configure JSSE.
	 */
	@ModelNodeBinding(detypedName = "additional-properties")
	public Map additionalProperties() {
		return this.additionalProperties;
	}

	/**
	 * Additional properties that may be necessary to configure JSSE.
	 */
	@SuppressWarnings("unchecked")
	public ClassicJsse additionalProperties(Map value) {
		this.additionalProperties = value;
		return (ClassicJsse) this;
	}

	/**
	 * Comma separated list of cipher suites to enable on SSLSockets.
	 */
	@ModelNodeBinding(detypedName = "cipher-suites")
	public String cipherSuites() {
		return this.cipherSuites;
	}

	/**
	 * Comma separated list of cipher suites to enable on SSLSockets.
	 */
	@SuppressWarnings("unchecked")
	public ClassicJsse cipherSuites(String value) {
		this.cipherSuites = value;
		return (ClassicJsse) this;
	}

	/**
	 * Preferred alias to use when the KeyManager chooses the client alias.
	 */
	@ModelNodeBinding(detypedName = "client-alias")
	public String clientAlias() {
		return this.clientAlias;
	}

	/**
	 * Preferred alias to use when the KeyManager chooses the client alias.
	 */
	@SuppressWarnings("unchecked")
	public ClassicJsse clientAlias(String value) {
		this.clientAlias = value;
		return (ClassicJsse) this;
	}

	/**
	 * Boolean attribute to indicate if client's certificates should also be authenticated on the server side.
	 */
	@ModelNodeBinding(detypedName = "client-auth")
	public Boolean clientAuth() {
		return this.clientAuth;
	}

	/**
	 * Boolean attribute to indicate if client's certificates should also be authenticated on the server side.
	 */
	@SuppressWarnings("unchecked")
	public ClassicJsse clientAuth(Boolean value) {
		this.clientAuth = value;
		return (ClassicJsse) this;
	}

	/**
	 * JSEE Key Manager factory
	 */
	@ModelNodeBinding(detypedName = "key-manager")
	public Map keyManager() {
		return this.keyManager;
	}

	/**
	 * JSEE Key Manager factory
	 */
	@SuppressWarnings("unchecked")
	public ClassicJsse keyManager(Map value) {
		this.keyManager = value;
		return (ClassicJsse) this;
	}

	/**
	 * Configures a JSSE key store
	 */
	@ModelNodeBinding(detypedName = "keystore")
	public Map keystore() {
		return this.keystore;
	}

	/**
	 * Configures a JSSE key store
	 */
	@SuppressWarnings("unchecked")
	public ClassicJsse keystore(Map value) {
		this.keystore = value;
		return (ClassicJsse) this;
	}

	/**
	 * Comma separated list of protocols to enable on SSLSockets.
	 */
	@ModelNodeBinding(detypedName = "protocols")
	public String protocols() {
		return this.protocols;
	}

	/**
	 * Comma separated list of protocols to enable on SSLSockets.
	 */
	@SuppressWarnings("unchecked")
	public ClassicJsse protocols(String value) {
		this.protocols = value;
		return (ClassicJsse) this;
	}

	/**
	 * Preferred alias to use when the KeyManager chooses the server alias.
	 */
	@ModelNodeBinding(detypedName = "server-alias")
	public String serverAlias() {
		return this.serverAlias;
	}

	/**
	 * Preferred alias to use when the KeyManager chooses the server alias.
	 */
	@SuppressWarnings("unchecked")
	public ClassicJsse serverAlias(String value) {
		this.serverAlias = value;
		return (ClassicJsse) this;
	}

	/**
	 * Token to retrieve PrivateKeys from the KeyStore.
	 */
	@ModelNodeBinding(detypedName = "service-auth-token")
	public String serviceAuthToken() {
		return this.serviceAuthToken;
	}

	/**
	 * Token to retrieve PrivateKeys from the KeyStore.
	 */
	@SuppressWarnings("unchecked")
	public ClassicJsse serviceAuthToken(String value) {
		this.serviceAuthToken = value;
		return (ClassicJsse) this;
	}

	/**
	 * JSEE Trust Manager factory
	 */
	@ModelNodeBinding(detypedName = "trust-manager")
	public Map trustManager() {
		return this.trustManager;
	}

	/**
	 * JSEE Trust Manager factory
	 */
	@SuppressWarnings("unchecked")
	public ClassicJsse trustManager(Map value) {
		this.trustManager = value;
		return (ClassicJsse) this;
	}

	/**
	 * Configures a JSSE trust store
	 */
	@ModelNodeBinding(detypedName = "truststore")
	public Map truststore() {
		return this.truststore;
	}

	/**
	 * Configures a JSSE trust store
	 */
	@SuppressWarnings("unchecked")
	public ClassicJsse truststore(Map value) {
		this.truststore = value;
		return (ClassicJsse) this;
	}
}