package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.mapping.MappingModule;
/**
 * Mapping configuration. Configures a list of mapping modules to be used for principal, role, attribute and credential mapping.
 */
@ResourceType("mapping")
@Implicit
public class ClassicMapping {

	private String key;
	private ClassicMappingResources subresources = new ClassicMappingResources();

	public ClassicMapping() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	public ClassicMappingResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.security.security_domain.mapping.MappingModule objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.security.security_domain.mapping.MappingModule objects.
	 */
	@SuppressWarnings("unchecked")
	public ClassicMapping mappingModules(
			List<org.wildfly.swarm.config.security.security_domain.mapping.MappingModule> value) {
		this.subresources.mappingModules.addAll(value);
		return (ClassicMapping) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.security.security_domain.mapping.MappingModule object to the list of subresources
	 * @param value The org.wildfly.swarm.config.security.security_domain.mapping.MappingModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicMapping mappingModule(MappingModule value) {
		this.subresources.mappingModules.add(value);
		return (ClassicMapping) this;
	}

	/**
	 * Child mutators for ClassicMapping
	 */
	public class ClassicMappingResources {
		/**
		 * List of modules that map principal, role, and credential information
		 */
		private List<org.wildfly.swarm.config.security.security_domain.mapping.MappingModule> mappingModules = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.security.security_domain.mapping.MappingModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<MappingModule> mappingModules() {
			return this.mappingModules;
		}
	}
}