package org.wildfly.swarm.config.transactions.log_store.transactions;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The resources that did work in a transaction.
 */
@ResourceType("participants")
public class Participants {

	private String key;
	private String eisProductName;
	private String eisProductVersion;
	private String jmxName;
	private String jndiName;
	private String status;
	private String type;

	public Participants(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The JCA enterprise information system's product name.
	 */
	@ModelNodeBinding(detypedName = "eis-product-name")
	public String eisProductName() {
		return this.eisProductName;
	}

	/**
	 * The JCA enterprise information system's product name.
	 */
	@SuppressWarnings("unchecked")
	public Participants eisProductName(String value) {
		this.eisProductName = value;
		return (Participants) this;
	}

	/**
	 * The JCA enterprise information system's product version
	 */
	@ModelNodeBinding(detypedName = "eis-product-version")
	public String eisProductVersion() {
		return this.eisProductVersion;
	}

	/**
	 * The JCA enterprise information system's product version
	 */
	@SuppressWarnings("unchecked")
	public Participants eisProductVersion(String value) {
		this.eisProductVersion = value;
		return (Participants) this;
	}

	/**
	 * The JMX name of this participant.
	 */
	@ModelNodeBinding(detypedName = "jmx-name")
	public String jmxName() {
		return this.jmxName;
	}

	/**
	 * The JMX name of this participant.
	 */
	@SuppressWarnings("unchecked")
	public Participants jmxName(String value) {
		this.jmxName = value;
		return (Participants) this;
	}

	/**
	 * JNDI name of this participant.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * JNDI name of this participant.
	 */
	@SuppressWarnings("unchecked")
	public Participants jndiName(String value) {
		this.jndiName = value;
		return (Participants) this;
	}

	/**
	 * Reports the commitment status of this participant (can be one of Pending, Prepared, Failed, Heuristic or Readonly).
	 */
	@ModelNodeBinding(detypedName = "status")
	public String status() {
		return this.status;
	}

	/**
	 * Reports the commitment status of this participant (can be one of Pending, Prepared, Failed, Heuristic or Readonly).
	 */
	@SuppressWarnings("unchecked")
	public Participants status(String value) {
		this.status = value;
		return (Participants) this;
	}

	/**
	 * The type name under which this record is stored.
	 */
	@ModelNodeBinding(detypedName = "type")
	public String type() {
		return this.type;
	}

	/**
	 * The type name under which this record is stored.
	 */
	@SuppressWarnings("unchecked")
	public Participants type(String value) {
		this.type = value;
		return (Participants) this;
	}
}