package org.wildfly.swarm.config.undertow.configuration;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A filter parsed from the undertow expression language
 */
@ResourceType("expression-filter")
public class ExpressionFilter {

	private String key;
	private String expression;
	private String module;

	public ExpressionFilter(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The expression that defines the filter
	 */
	@ModelNodeBinding(detypedName = "expression")
	public String expression() {
		return this.expression;
	}

	/**
	 * The expression that defines the filter
	 */
	@SuppressWarnings("unchecked")
	public ExpressionFilter expression(String value) {
		this.expression = value;
		return (ExpressionFilter) this;
	}

	/**
	 * Module to use to load the filter definitions
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * Module to use to load the filter definitions
	 */
	@SuppressWarnings("unchecked")
	public ExpressionFilter module(String value) {
		this.module = value;
		return (ExpressionFilter) this;
	}
}