package org.wildfly.swarm.config.undertow.server.host;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The SSO configuration for this virtual server.
 */
@ResourceType("setting")
@Implicit
public class SingleSignOnSetting {

	private String key;
	private String cookieName;
	private String domain;
	private Boolean httpOnly;
	private String path;
	private Boolean secure;

	public SingleSignOnSetting() {
		this.key = "single-sign-on";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Name of the cookie
	 */
	@ModelNodeBinding(detypedName = "cookie-name")
	public String cookieName() {
		return this.cookieName;
	}

	/**
	 * Name of the cookie
	 */
	@SuppressWarnings("unchecked")
	public SingleSignOnSetting cookieName(String value) {
		this.cookieName = value;
		return (SingleSignOnSetting) this;
	}

	/**
	 * The cookie domain that will be used.
	 */
	@ModelNodeBinding(detypedName = "domain")
	public String domain() {
		return this.domain;
	}

	/**
	 * The cookie domain that will be used.
	 */
	@SuppressWarnings("unchecked")
	public SingleSignOnSetting domain(String value) {
		this.domain = value;
		return (SingleSignOnSetting) this;
	}

	/**
	 * Set Cookie httpOnly attribute.
	 */
	@ModelNodeBinding(detypedName = "http-only")
	public Boolean httpOnly() {
		return this.httpOnly;
	}

	/**
	 * Set Cookie httpOnly attribute.
	 */
	@SuppressWarnings("unchecked")
	public SingleSignOnSetting httpOnly(Boolean value) {
		this.httpOnly = value;
		return (SingleSignOnSetting) this;
	}

	/**
	 * Cookie path.
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * Cookie path.
	 */
	@SuppressWarnings("unchecked")
	public SingleSignOnSetting path(String value) {
		this.path = value;
		return (SingleSignOnSetting) this;
	}

	/**
	 * Set Cookie secure attribute.
	 */
	@ModelNodeBinding(detypedName = "secure")
	public Boolean secure() {
		return this.secure;
	}

	/**
	 * Set Cookie secure attribute.
	 */
	@SuppressWarnings("unchecked")
	public SingleSignOnSetting secure(Boolean value) {
		this.secure = value;
		return (SingleSignOnSetting) this;
	}
}