package org.wildfly.swarm.config.undertow.servlet_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The servlet container mime mapping config
 */
@ResourceType("mime-mapping")
public class MimeMapping {

	private String key;
	private String value;

	public MimeMapping(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The mime type for this mapping
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * The mime type for this mapping
	 */
	@SuppressWarnings("unchecked")
	public MimeMapping value(String value) {
		this.value = value;
		return (MimeMapping) this;
	}
}