package org.wildfly.swarm.config.undertow.servlet_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Session cookie configuration
 */
@ResourceType("setting")
@Implicit
public class SessionCookieSetting {

	private String key;
	private String comment;
	private String domain;
	private Boolean httpOnly;
	private Integer maxAge;
	private String name;
	private Boolean secure;

	public SessionCookieSetting() {
		this.key = "session-cookie";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Cookie comment
	 */
	@ModelNodeBinding(detypedName = "comment")
	public String comment() {
		return this.comment;
	}

	/**
	 * Cookie comment
	 */
	@SuppressWarnings("unchecked")
	public SessionCookieSetting comment(String value) {
		this.comment = value;
		return (SessionCookieSetting) this;
	}

	/**
	 * Cookie domain
	 */
	@ModelNodeBinding(detypedName = "domain")
	public String domain() {
		return this.domain;
	}

	/**
	 * Cookie domain
	 */
	@SuppressWarnings("unchecked")
	public SessionCookieSetting domain(String value) {
		this.domain = value;
		return (SessionCookieSetting) this;
	}

	/**
	 * Is cookie http-only
	 */
	@ModelNodeBinding(detypedName = "http-only")
	public Boolean httpOnly() {
		return this.httpOnly;
	}

	/**
	 * Is cookie http-only
	 */
	@SuppressWarnings("unchecked")
	public SessionCookieSetting httpOnly(Boolean value) {
		this.httpOnly = value;
		return (SessionCookieSetting) this;
	}

	/**
	 * Max age of cookie
	 */
	@ModelNodeBinding(detypedName = "max-age")
	public Integer maxAge() {
		return this.maxAge;
	}

	/**
	 * Max age of cookie
	 */
	@SuppressWarnings("unchecked")
	public SessionCookieSetting maxAge(Integer value) {
		this.maxAge = value;
		return (SessionCookieSetting) this;
	}

	/**
	 * Name of the cookie
	 */
	@ModelNodeBinding(detypedName = "name")
	public String name() {
		return this.name;
	}

	/**
	 * Name of the cookie
	 */
	@SuppressWarnings("unchecked")
	public SessionCookieSetting name(String value) {
		this.name = value;
		return (SessionCookieSetting) this;
	}

	/**
	 * Is cookie secure?
	 */
	@ModelNodeBinding(detypedName = "secure")
	public Boolean secure() {
		return this.secure;
	}

	/**
	 * Is cookie secure?
	 */
	@SuppressWarnings("unchecked")
	public SessionCookieSetting secure(Boolean value) {
		this.secure = value;
		return (SessionCookieSetting) this;
	}
}