package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.io.Worker;
import org.wildfly.swarm.config.io.WorkerConfigurator;
import org.wildfly.swarm.config.io.BufferPool;
import org.wildfly.swarm.config.io.BufferPoolConfigurator;
/**
 * IO subsystem
 */
@ResourceType("subsystem")
@Implicit
public class Io<T extends Io> {

	private String key;
	private IoResources subresources = new IoResources();

	public Io() {
		this.key = "io";
	}

	public String getKey() {
		return this.key;
	}

	public IoResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.io.Worker objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.io.Worker objects.
	 */
	@SuppressWarnings("unchecked")
	public T workers(List<org.wildfly.swarm.config.io.Worker> value) {
		this.subresources.workers.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.io.Worker object to the list of subresources
	 * @param value The org.wildfly.swarm.config.io.Worker to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T worker(Worker value) {
		this.subresources.workers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.io.Worker object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.io.Worker resource
	 * @param config The org.wildfly.swarm.config.io.WorkerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T worker(String childKey, WorkerConfigurator config) {
		org.wildfly.swarm.config.io.Worker child = new org.wildfly.swarm.config.io.Worker(
				childKey);
		config.configure(child);
		worker(child);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.io.BufferPool objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.io.BufferPool objects.
	 */
	@SuppressWarnings("unchecked")
	public T bufferPools(List<org.wildfly.swarm.config.io.BufferPool> value) {
		this.subresources.bufferPools.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.io.BufferPool object to the list of subresources
	 * @param value The org.wildfly.swarm.config.io.BufferPool to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bufferPool(BufferPool value) {
		this.subresources.bufferPools.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.io.BufferPool object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.io.BufferPool resource
	 * @param config The org.wildfly.swarm.config.io.BufferPoolConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bufferPool(String childKey, BufferPoolConfigurator config) {
		org.wildfly.swarm.config.io.BufferPool child = new org.wildfly.swarm.config.io.BufferPool(
				childKey);
		config.configure(child);
		bufferPool(child);
		return (T) this;
	}

	/**
	 * Child mutators for Io
	 */
	public class IoResources {
		/**
		 * Defines workers
		 */
		private List<org.wildfly.swarm.config.io.Worker> workers = new java.util.ArrayList<>();
		/**
		 * Defines buffer pool
		 */
		private List<org.wildfly.swarm.config.io.BufferPool> bufferPools = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.io.Worker resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Worker> workers() {
			return this.workers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.io.BufferPool resources
		 * @return the list of resources
		 */
		@Subresource
		public List<BufferPool> bufferPools() {
			return this.bufferPools;
		}
	}
}