package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.Server;
import org.wildfly.swarm.config.undertow.ServerConfigurator;
import org.wildfly.swarm.config.undertow.BufferCache;
import org.wildfly.swarm.config.undertow.BufferCacheConfigurator;
import org.wildfly.swarm.config.undertow.ServletContainer;
import org.wildfly.swarm.config.undertow.ServletContainerConfigurator;
import org.wildfly.swarm.config.undertow.HandlerConfiguration;
import org.wildfly.swarm.config.undertow.FilterConfiguration;
/**
 * Undertow subsystem
 */
@ResourceType("subsystem")
@Implicit
public class Undertow<T extends Undertow> {

	private String key;
	private String defaultServer;
	private String defaultServletContainer;
	private String defaultVirtualHost;
	private String instanceId;
	private Boolean statisticsEnabled;
	private UndertowResources subresources = new UndertowResources();
	private HandlerConfiguration handlerConfiguration;
	private FilterConfiguration filterConfiguration;

	public Undertow() {
		this.key = "undertow";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The default server to use for deployments
	 */
	@ModelNodeBinding(detypedName = "default-server")
	public String defaultServer() {
		return this.defaultServer;
	}

	/**
	 * The default server to use for deployments
	 */
	@SuppressWarnings("unchecked")
	public T defaultServer(String value) {
		this.defaultServer = value;
		return (T) this;
	}

	/**
	 * The default servlet container to use for deployments
	 */
	@ModelNodeBinding(detypedName = "default-servlet-container")
	public String defaultServletContainer() {
		return this.defaultServletContainer;
	}

	/**
	 * The default servlet container to use for deployments
	 */
	@SuppressWarnings("unchecked")
	public T defaultServletContainer(String value) {
		this.defaultServletContainer = value;
		return (T) this;
	}

	/**
	 * The default virtual host to use for deployments
	 */
	@ModelNodeBinding(detypedName = "default-virtual-host")
	public String defaultVirtualHost() {
		return this.defaultVirtualHost;
	}

	/**
	 * The default virtual host to use for deployments
	 */
	@SuppressWarnings("unchecked")
	public T defaultVirtualHost(String value) {
		this.defaultVirtualHost = value;
		return (T) this;
	}

	/**
	 * The cluster instance id
	 */
	@ModelNodeBinding(detypedName = "instance-id")
	public String instanceId() {
		return this.instanceId;
	}

	/**
	 * The cluster instance id
	 */
	@SuppressWarnings("unchecked")
	public T instanceId(String value) {
		this.instanceId = value;
		return (T) this;
	}

	/**
	 * Configures if are statistics enabled
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * Configures if are statistics enabled
	 */
	@SuppressWarnings("unchecked")
	public T statisticsEnabled(Boolean value) {
		this.statisticsEnabled = value;
		return (T) this;
	}

	public UndertowResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.Server objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.Server objects.
	 */
	@SuppressWarnings("unchecked")
	public T servers(List<org.wildfly.swarm.config.undertow.Server> value) {
		this.subresources.servers.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.Server object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.Server to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T server(Server value) {
		this.subresources.servers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.Server object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.Server resource
	 * @param config The org.wildfly.swarm.config.undertow.ServerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T server(String childKey, ServerConfigurator config) {
		org.wildfly.swarm.config.undertow.Server child = new org.wildfly.swarm.config.undertow.Server(
				childKey);
		config.configure(child);
		server(child);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.BufferCache objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.BufferCache objects.
	 */
	@SuppressWarnings("unchecked")
	public T bufferCaches(
			List<org.wildfly.swarm.config.undertow.BufferCache> value) {
		this.subresources.bufferCaches.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.BufferCache object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.BufferCache to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bufferCache(BufferCache value) {
		this.subresources.bufferCaches.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.BufferCache object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.BufferCache resource
	 * @param config The org.wildfly.swarm.config.undertow.BufferCacheConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T bufferCache(String childKey, BufferCacheConfigurator config) {
		org.wildfly.swarm.config.undertow.BufferCache child = new org.wildfly.swarm.config.undertow.BufferCache(
				childKey);
		config.configure(child);
		bufferCache(child);
		return (T) this;
	}

	/**
	 * Add all org.wildfly.swarm.config.undertow.ServletContainer objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.undertow.ServletContainer objects.
	 */
	@SuppressWarnings("unchecked")
	public T servletContainers(
			List<org.wildfly.swarm.config.undertow.ServletContainer> value) {
		this.subresources.servletContainers.addAll(value);
		return (T) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.undertow.ServletContainer object to the list of subresources
	 * @param value The org.wildfly.swarm.config.undertow.ServletContainer to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T servletContainer(ServletContainer value) {
		this.subresources.servletContainers.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.undertow.ServletContainer object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.undertow.ServletContainer resource
	 * @param config The org.wildfly.swarm.config.undertow.ServletContainerConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T servletContainer(String childKey,
			ServletContainerConfigurator config) {
		org.wildfly.swarm.config.undertow.ServletContainer child = new org.wildfly.swarm.config.undertow.ServletContainer(
				childKey);
		config.configure(child);
		servletContainer(child);
		return (T) this;
	}

	/**
	 * Child mutators for Undertow
	 */
	public class UndertowResources {
		/**
		 * A server
		 */
		private List<org.wildfly.swarm.config.undertow.Server> servers = new java.util.ArrayList<>();
		/**
		 * The buffer cache used to cache static content
		 */
		private List<org.wildfly.swarm.config.undertow.BufferCache> bufferCaches = new java.util.ArrayList<>();
		/**
		 * A servlet container
		 */
		private List<org.wildfly.swarm.config.undertow.ServletContainer> servletContainers = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.Server resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Server> servers() {
			return this.servers;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.BufferCache resources
		 * @return the list of resources
		 */
		@Subresource
		public List<BufferCache> bufferCaches() {
			return this.bufferCaches;
		}

		/**
		 * Get the list of org.wildfly.swarm.config.undertow.ServletContainer resources
		 * @return the list of resources
		 */
		@Subresource
		public List<ServletContainer> servletContainers() {
			return this.servletContainers;
		}
	}

	/**
	 * Undertow handlers
	 */
	@Subresource
	public HandlerConfiguration handlerConfiguration() {
		return this.handlerConfiguration;
	}

	/**
	 * Undertow handlers
	 */
	@SuppressWarnings("unchecked")
	public T handlerConfiguration(HandlerConfiguration value) {
		this.handlerConfiguration = value;
		return (T) this;
	}

	/**
	 * Undertow filters
	 */
	@Subresource
	public FilterConfiguration filterConfiguration() {
		return this.filterConfiguration;
	}

	/**
	 * Undertow filters
	 */
	@SuppressWarnings("unchecked")
	public T filterConfiguration(FilterConfiguration value) {
		this.filterConfiguration = value;
		return (T) this;
	}
}