package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
/**
 * A SFSB cache
 */
@ResourceType("cache")
public class Cache<T extends Cache> {

	private String key;
	private List<String> aliases;
	private String passivationStore;

	public Cache(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The aliases by which this cache may also be referenced
	 */
	@ModelNodeBinding(detypedName = "aliases")
	public List<String> aliases() {
		return this.aliases;
	}

	/**
	 * The aliases by which this cache may also be referenced
	 */
	@SuppressWarnings("unchecked")
	public Cache aliases(List<String> value) {
		this.aliases = value;
		return (Cache) this;
	}

	/**
	 * The passivation store used by this cache
	 */
	@ModelNodeBinding(detypedName = "passivation-store")
	public String passivationStore() {
		return this.passivationStore;
	}

	/**
	 * The passivation store used by this cache
	 */
	@SuppressWarnings("unchecked")
	public Cache passivationStore(String value) {
		this.passivationStore = value;
		return (Cache) this;
	}
}