package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Configures a cache store as write-behind instead of write-through.
 */
@ResourceType("write")
@Implicit
public class BehindWrite<T extends BehindWrite> {

	private String key;
	private Integer modificationQueueSize;
	private Integer threadPoolSize;

	public BehindWrite() {
		this.key = "behind";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Maximum number of entries in the asynchronous queue. When the queue is full, the store becomes write-through until it can accept new entries.
	 */
	@ModelNodeBinding(detypedName = "modification-queue-size")
	public Integer modificationQueueSize() {
		return this.modificationQueueSize;
	}

	/**
	 * Maximum number of entries in the asynchronous queue. When the queue is full, the store becomes write-through until it can accept new entries.
	 */
	@SuppressWarnings("unchecked")
	public BehindWrite modificationQueueSize(Integer value) {
		this.modificationQueueSize = value;
		return (BehindWrite) this;
	}

	/**
	 * Size of the thread pool whose threads are responsible for applying the modifications to the cache store.
	 */
	@ModelNodeBinding(detypedName = "thread-pool-size")
	public Integer threadPoolSize() {
		return this.threadPoolSize;
	}

	/**
	 * Size of the thread pool whose threads are responsible for applying the modifications to the cache store.
	 */
	@SuppressWarnings("unchecked")
	public BehindWrite threadPoolSize(Integer value) {
		this.threadPoolSize = value;
		return (BehindWrite) this;
	}
}