package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * Defines a table used to store cache entries whose keys cannot be expressed as strings.
 */
@ResourceType("table")
@Implicit
public class BinaryTable<T extends BinaryTable> {

	private String key;
	private Integer batchSize;
	private Map dataColumn;
	private Integer fetchSize;
	private Map idColumn;
	private String prefix;
	private Map timestampColumn;

	public BinaryTable() {
		this.key = "binary";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * For DB inserts, the batch size determines how many inserts are batched together.
	 */
	@ModelNodeBinding(detypedName = "batch-size")
	public Integer batchSize() {
		return this.batchSize;
	}

	/**
	 * For DB inserts, the batch size determines how many inserts are batched together.
	 */
	@SuppressWarnings("unchecked")
	public BinaryTable batchSize(Integer value) {
		this.batchSize = value;
		return (BinaryTable) this;
	}

	/**
	 * A database column to hold cache entry data.
	 */
	@ModelNodeBinding(detypedName = "data-column")
	public Map dataColumn() {
		return this.dataColumn;
	}

	/**
	 * A database column to hold cache entry data.
	 */
	@SuppressWarnings("unchecked")
	public BinaryTable dataColumn(Map value) {
		this.dataColumn = value;
		return (BinaryTable) this;
	}

	/**
	 * For DB queries, the fetch size will be used to set the fetch size on ResultSets.
	 */
	@ModelNodeBinding(detypedName = "fetch-size")
	public Integer fetchSize() {
		return this.fetchSize;
	}

	/**
	 * For DB queries, the fetch size will be used to set the fetch size on ResultSets.
	 */
	@SuppressWarnings("unchecked")
	public BinaryTable fetchSize(Integer value) {
		this.fetchSize = value;
		return (BinaryTable) this;
	}

	/**
	 * A database column to hold cache entry ids.
	 */
	@ModelNodeBinding(detypedName = "id-column")
	public Map idColumn() {
		return this.idColumn;
	}

	/**
	 * A database column to hold cache entry ids.
	 */
	@SuppressWarnings("unchecked")
	public BinaryTable idColumn(Map value) {
		this.idColumn = value;
		return (BinaryTable) this;
	}

	/**
	 * The prefix for the database table name.
	 */
	@ModelNodeBinding(detypedName = "prefix")
	public String prefix() {
		return this.prefix;
	}

	/**
	 * The prefix for the database table name.
	 */
	@SuppressWarnings("unchecked")
	public BinaryTable prefix(String value) {
		this.prefix = value;
		return (BinaryTable) this;
	}

	/**
	 * A database column to hold cache entry timestamps.
	 */
	@ModelNodeBinding(detypedName = "timestamp-column")
	public Map timestampColumn() {
		return this.timestampColumn;
	}

	/**
	 * A database column to hold cache entry timestamps.
	 */
	@SuppressWarnings("unchecked")
	public BinaryTable timestampColumn(Map value) {
		this.timestampColumn = value;
		return (BinaryTable) this;
	}
}