package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Defines a thread pool used for for evictions.
 */
@ResourceType("thread-pool")
@Implicit
public class ExpirationThreadPool<T extends ExpirationThreadPool> {

	private String key;
	private Long keepaliveTime;
	private Integer maxThreads;

	public ExpirationThreadPool() {
		this.key = "expiration";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Used to specify the amount of milliseconds that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.
	 */
	@ModelNodeBinding(detypedName = "keepalive-time")
	public Long keepaliveTime() {
		return this.keepaliveTime;
	}

	/**
	 * Used to specify the amount of milliseconds that pool threads should be kept running when idle; if not specified, threads will run until the executor is shut down.
	 */
	@SuppressWarnings("unchecked")
	public ExpirationThreadPool keepaliveTime(Long value) {
		this.keepaliveTime = value;
		return (ExpirationThreadPool) this;
	}

	/**
	 * The maximum thread pool size.
	 */
	@ModelNodeBinding(detypedName = "max-threads")
	public Integer maxThreads() {
		return this.maxThreads;
	}

	/**
	 * The maximum thread pool size.
	 */
	@SuppressWarnings("unchecked")
	public ExpirationThreadPool maxThreads(Integer value) {
		this.maxThreads = value;
		return (ExpirationThreadPool) this;
	}
}