package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.Subresource;
/**
 * An invalidation cache
 */
@ResourceType("invalidation-cache")
public class InvalidationCache<T extends InvalidationCache> {

	private String key;
	private Long activations;
	private Long averageReadTime;
	private Long averageReplicationTime;
	private Long averageWriteTime;
	private String cacheStatus;
	private Long elapsedTime;
	private Double hitRatio;
	private Long hits;
	private Long invalidations;
	private String jndiName;
	private Long misses;
	private String mode;
	private String module;
	private Integer numberOfEntries;
	private Long passivations;
	private Long queueFlushInterval;
	private Integer queueSize;
	private Double readWriteRatio;
	private Long remoteTimeout;
	private Long removeHits;
	private Long removeMisses;
	private Long replicationCount;
	private Long replicationFailures;
	private Boolean statisticsEnabled;
	private Long stores;
	private Double successRatio;
	private Long timeSinceReset;
	private EvictionComponent evictionComponent;
	private StringJdbcStore stringJdbcStore;
	private CustomStore customStore;
	private ExpirationComponent expirationComponent;
	private FileStore fileStore;
	private NoneStore noneStore;
	private TransactionComponent transactionComponent;
	private LockingComponent lockingComponent;
	private BinaryJdbcStore binaryJdbcStore;
	private MixedJdbcStore mixedJdbcStore;
	private RemoteStore remoteStore;

	public InvalidationCache(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The number of cache node activations (bringing a node into memory from a cache store) . May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "activations")
	public Long activations() {
		return this.activations;
	}

	/**
	 * The number of cache node activations (bringing a node into memory from a cache store) . May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache activations(Long value) {
		this.activations = value;
		return (InvalidationCache) this;
	}

	/**
	 * Average time (in ms) for cache reads. Includes hits and misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "average-read-time")
	public Long averageReadTime() {
		return this.averageReadTime;
	}

	/**
	 * Average time (in ms) for cache reads. Includes hits and misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache averageReadTime(Long value) {
		this.averageReadTime = value;
		return (InvalidationCache) this;
	}

	/**
	 * The average time taken to replicate data around the cluster. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "average-replication-time")
	public Long averageReplicationTime() {
		return this.averageReplicationTime;
	}

	/**
	 * The average time taken to replicate data around the cluster. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache averageReplicationTime(Long value) {
		this.averageReplicationTime = value;
		return (InvalidationCache) this;
	}

	/**
	 * Average time (in ms) for cache writes. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "average-write-time")
	public Long averageWriteTime() {
		return this.averageWriteTime;
	}

	/**
	 * Average time (in ms) for cache writes. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache averageWriteTime(Long value) {
		this.averageWriteTime = value;
		return (InvalidationCache) this;
	}

	/**
	 * The status of the cache component. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "cache-status")
	public String cacheStatus() {
		return this.cacheStatus;
	}

	/**
	 * The status of the cache component. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache cacheStatus(String value) {
		this.cacheStatus = value;
		return (InvalidationCache) this;
	}

	/**
	 * Time (in secs) since cache started. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "elapsed-time")
	public Long elapsedTime() {
		return this.elapsedTime;
	}

	/**
	 * Time (in secs) since cache started. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache elapsedTime(Long value) {
		this.elapsedTime = value;
		return (InvalidationCache) this;
	}

	/**
	 * The hit/miss ratio for the cache (hits/hits+misses). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "hit-ratio")
	public Double hitRatio() {
		return this.hitRatio;
	}

	/**
	 * The hit/miss ratio for the cache (hits/hits+misses). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache hitRatio(Double value) {
		this.hitRatio = value;
		return (InvalidationCache) this;
	}

	/**
	 * The number of cache attribute hits. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "hits")
	public Long hits() {
		return this.hits;
	}

	/**
	 * The number of cache attribute hits. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache hits(Long value) {
		this.hits = value;
		return (InvalidationCache) this;
	}

	/**
	 * The number of cache invalidations. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "invalidations")
	public Long invalidations() {
		return this.invalidations;
	}

	/**
	 * The number of cache invalidations. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache invalidations(Long value) {
		this.invalidations = value;
		return (InvalidationCache) this;
	}

	/**
	 * The jndi-name to which to bind this cache instance.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * The jndi-name to which to bind this cache instance.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache jndiName(String value) {
		this.jndiName = value;
		return (InvalidationCache) this;
	}

	/**
	 * The number of cache attribute misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "misses")
	public Long misses() {
		return this.misses;
	}

	/**
	 * The number of cache attribute misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache misses(Long value) {
		this.misses = value;
		return (InvalidationCache) this;
	}

	/**
	 * Sets the clustered cache mode, ASYNC for asynchronous operation, or SYNC for synchronous operation.
	 */
	@ModelNodeBinding(detypedName = "mode")
	public String mode() {
		return this.mode;
	}

	/**
	 * Sets the clustered cache mode, ASYNC for asynchronous operation, or SYNC for synchronous operation.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache mode(String value) {
		this.mode = value;
		return (InvalidationCache) this;
	}

	/**
	 * The module whose class loader should be used when building this cache's configuration.
	 */
	@ModelNodeBinding(detypedName = "module")
	public String module() {
		return this.module;
	}

	/**
	 * The module whose class loader should be used when building this cache's configuration.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache module(String value) {
		this.module = value;
		return (InvalidationCache) this;
	}

	/**
	 * The current number of entries in the cache. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "number-of-entries")
	public Integer numberOfEntries() {
		return this.numberOfEntries;
	}

	/**
	 * The current number of entries in the cache. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache numberOfEntries(Integer value) {
		this.numberOfEntries = value;
		return (InvalidationCache) this;
	}

	/**
	 * The number of cache node passivations (passivating a node from memory to a cache store). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "passivations")
	public Long passivations() {
		return this.passivations;
	}

	/**
	 * The number of cache node passivations (passivating a node from memory to a cache store). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache passivations(Long value) {
		this.passivations = value;
		return (InvalidationCache) this;
	}

	/**
	 * In ASYNC mode, this attribute controls how often the asynchronous thread used to flush the replication queue runs. This should be a positive integer which represents thread wakeup time in milliseconds.
	 */
	@ModelNodeBinding(detypedName = "queue-flush-interval")
	public Long queueFlushInterval() {
		return this.queueFlushInterval;
	}

	/**
	 * In ASYNC mode, this attribute controls how often the asynchronous thread used to flush the replication queue runs. This should be a positive integer which represents thread wakeup time in milliseconds.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache queueFlushInterval(Long value) {
		this.queueFlushInterval = value;
		return (InvalidationCache) this;
	}

	/**
	 * In ASYNC mode, this attribute can be used to trigger flushing of the queue when it reaches a specific threshold.
	 */
	@ModelNodeBinding(detypedName = "queue-size")
	public Integer queueSize() {
		return this.queueSize;
	}

	/**
	 * In ASYNC mode, this attribute can be used to trigger flushing of the queue when it reaches a specific threshold.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache queueSize(Integer value) {
		this.queueSize = value;
		return (InvalidationCache) this;
	}

	/**
	 * The read/write ratio of the cache ((hits+misses)/stores). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "read-write-ratio")
	public Double readWriteRatio() {
		return this.readWriteRatio;
	}

	/**
	 * The read/write ratio of the cache ((hits+misses)/stores). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache readWriteRatio(Double value) {
		this.readWriteRatio = value;
		return (InvalidationCache) this;
	}

	/**
	 * In SYNC mode, the timeout (in ms) used to wait for an acknowledgment when making a remote call, after which the call is aborted and an exception is thrown.
	 */
	@ModelNodeBinding(detypedName = "remote-timeout")
	public Long remoteTimeout() {
		return this.remoteTimeout;
	}

	/**
	 * In SYNC mode, the timeout (in ms) used to wait for an acknowledgment when making a remote call, after which the call is aborted and an exception is thrown.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache remoteTimeout(Long value) {
		this.remoteTimeout = value;
		return (InvalidationCache) this;
	}

	/**
	 * The number of cache attribute remove hits. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "remove-hits")
	public Long removeHits() {
		return this.removeHits;
	}

	/**
	 * The number of cache attribute remove hits. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache removeHits(Long value) {
		this.removeHits = value;
		return (InvalidationCache) this;
	}

	/**
	 * The number of cache attribute remove misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "remove-misses")
	public Long removeMisses() {
		return this.removeMisses;
	}

	/**
	 * The number of cache attribute remove misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache removeMisses(Long value) {
		this.removeMisses = value;
		return (InvalidationCache) this;
	}

	/**
	 * The number of times data was replicated around the cluster. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "replication-count")
	public Long replicationCount() {
		return this.replicationCount;
	}

	/**
	 * The number of times data was replicated around the cluster. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache replicationCount(Long value) {
		this.replicationCount = value;
		return (InvalidationCache) this;
	}

	/**
	 * The number of data replication failures. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "replication-failures")
	public Long replicationFailures() {
		return this.replicationFailures;
	}

	/**
	 * The number of data replication failures. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache replicationFailures(Long value) {
		this.replicationFailures = value;
		return (InvalidationCache) this;
	}

	/**
	 * If enabled, statistics will be collected for this cache
	 */
	@ModelNodeBinding(detypedName = "statistics-enabled")
	public Boolean statisticsEnabled() {
		return this.statisticsEnabled;
	}

	/**
	 * If enabled, statistics will be collected for this cache
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache statisticsEnabled(Boolean value) {
		this.statisticsEnabled = value;
		return (InvalidationCache) this;
	}

	/**
	 * The number of cache attribute put operations. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "stores")
	public Long stores() {
		return this.stores;
	}

	/**
	 * The number of cache attribute put operations. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache stores(Long value) {
		this.stores = value;
		return (InvalidationCache) this;
	}

	/**
	 * The data replication success ratio (successes/successes+failures). May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "success-ratio")
	public Double successRatio() {
		return this.successRatio;
	}

	/**
	 * The data replication success ratio (successes/successes+failures). May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache successRatio(Double value) {
		this.successRatio = value;
		return (InvalidationCache) this;
	}

	/**
	 * Time (in secs) since cache statistics were reset. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "time-since-reset")
	public Long timeSinceReset() {
		return this.timeSinceReset;
	}

	/**
	 * Time (in secs) since cache statistics were reset. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache timeSinceReset(Long value) {
		this.timeSinceReset = value;
		return (InvalidationCache) this;
	}

	/**
	 * The cache eviction configuration.
	 */
	@Subresource
	public EvictionComponent evictionComponent() {
		return this.evictionComponent;
	}

	/**
	 * The cache eviction configuration.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache evictionComponent(EvictionComponent value) {
		this.evictionComponent = value;
		return (InvalidationCache) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@Subresource
	public StringJdbcStore stringJdbcStore() {
		return this.stringJdbcStore;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache stringJdbcStore(StringJdbcStore value) {
		this.stringJdbcStore = value;
		return (InvalidationCache) this;
	}

	/**
	 * The cache store configuration.
	 */
	@Subresource
	public CustomStore customStore() {
		return this.customStore;
	}

	/**
	 * The cache store configuration.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache customStore(CustomStore value) {
		this.customStore = value;
		return (InvalidationCache) this;
	}

	/**
	 * The cache expiration configuration.
	 */
	@Subresource
	public ExpirationComponent expirationComponent() {
		return this.expirationComponent;
	}

	/**
	 * The cache expiration configuration.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache expirationComponent(ExpirationComponent value) {
		this.expirationComponent = value;
		return (InvalidationCache) this;
	}

	/**
	 * The cache file store configuration.
	 */
	@Subresource
	public FileStore fileStore() {
		return this.fileStore;
	}

	/**
	 * The cache file store configuration.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache fileStore(FileStore value) {
		this.fileStore = value;
		return (InvalidationCache) this;
	}

	/**
	 * A store-less configuration.
	 */
	@Subresource
	public NoneStore noneStore() {
		return this.noneStore;
	}

	/**
	 * A store-less configuration.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache noneStore(NoneStore value) {
		this.noneStore = value;
		return (InvalidationCache) this;
	}

	/**
	 * The cache transaction configuration.
	 */
	@Subresource
	public TransactionComponent transactionComponent() {
		return this.transactionComponent;
	}

	/**
	 * The cache transaction configuration.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache transactionComponent(TransactionComponent value) {
		this.transactionComponent = value;
		return (InvalidationCache) this;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@Subresource
	public LockingComponent lockingComponent() {
		return this.lockingComponent;
	}

	/**
	 * The locking configuration of the cache.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache lockingComponent(LockingComponent value) {
		this.lockingComponent = value;
		return (InvalidationCache) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@Subresource
	public BinaryJdbcStore binaryJdbcStore() {
		return this.binaryJdbcStore;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache binaryJdbcStore(BinaryJdbcStore value) {
		this.binaryJdbcStore = value;
		return (InvalidationCache) this;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@Subresource
	public MixedJdbcStore mixedJdbcStore() {
		return this.mixedJdbcStore;
	}

	/**
	 * The cache JDBC store configuration.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache mixedJdbcStore(MixedJdbcStore value) {
		this.mixedJdbcStore = value;
		return (InvalidationCache) this;
	}

	/**
	 * The cache remote store configuration.
	 */
	@Subresource
	public RemoteStore remoteStore() {
		return this.remoteStore;
	}

	/**
	 * The cache remote store configuration.
	 */
	@SuppressWarnings("unchecked")
	public InvalidationCache remoteStore(RemoteStore value) {
		this.remoteStore = value;
		return (InvalidationCache) this;
	}
}