package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
/**
 * The cache remote store configuration.
 */
@ResourceType("store")
@Implicit
public class RemoteStore<T extends RemoteStore> {

	private String key;
	private String cache;
	private Long cacheLoaderLoads;
	private Long cacheLoaderMisses;
	private Boolean fetchState;
	private Boolean passivation;
	private Boolean preload;
	private Map properties;
	private Boolean purge;
	private List<String> remoteServers;
	private Boolean shared;
	private Boolean singleton;
	private Long socketTimeout;
	private Boolean tcpNoDelay;
	private RemoteStoreResources subresources = new RemoteStoreResources();
	private ThroughWrite throughWrite;
	private BehindWrite behindWrite;

	public RemoteStore() {
		this.key = "remote";
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The name of the remote cache to use for this remote store.
	 */
	@ModelNodeBinding(detypedName = "cache")
	public String cache() {
		return this.cache;
	}

	/**
	 * The name of the remote cache to use for this remote store.
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore cache(String value) {
		this.cache = value;
		return (RemoteStore) this;
	}

	/**
	 * The number of cache loader node loads. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "cache-loader-loads")
	public Long cacheLoaderLoads() {
		return this.cacheLoaderLoads;
	}

	/**
	 * The number of cache loader node loads. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore cacheLoaderLoads(Long value) {
		this.cacheLoaderLoads = value;
		return (RemoteStore) this;
	}

	/**
	 * The number of cache loader node misses. May return null if the cache is not started.
	 */
	@ModelNodeBinding(detypedName = "cache-loader-misses")
	public Long cacheLoaderMisses() {
		return this.cacheLoaderMisses;
	}

	/**
	 * The number of cache loader node misses. May return null if the cache is not started.
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore cacheLoaderMisses(Long value) {
		this.cacheLoaderMisses = value;
		return (RemoteStore) this;
	}

	/**
	 * If true, fetch persistent state when joining a cluster. If multiple cache stores are chained, only one of them can have this property enabled.
	 */
	@ModelNodeBinding(detypedName = "fetch-state")
	public Boolean fetchState() {
		return this.fetchState;
	}

	/**
	 * If true, fetch persistent state when joining a cluster. If multiple cache stores are chained, only one of them can have this property enabled.
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore fetchState(Boolean value) {
		this.fetchState = value;
		return (RemoteStore) this;
	}

	/**
	 * If true, data is only written to the cache store when it is evicted from memory, a phenomenon known as 'passivation'. Next time the data is requested, it will be 'activated' which means that data will be brought back to memory and removed from the persistent store. f false, the cache store contains a copy of the contents in memory, so writes to cache result in cache store writes. This essentially gives you a 'write-through' configuration.
	 */
	@ModelNodeBinding(detypedName = "passivation")
	public Boolean passivation() {
		return this.passivation;
	}

	/**
	 * If true, data is only written to the cache store when it is evicted from memory, a phenomenon known as 'passivation'. Next time the data is requested, it will be 'activated' which means that data will be brought back to memory and removed from the persistent store. f false, the cache store contains a copy of the contents in memory, so writes to cache result in cache store writes. This essentially gives you a 'write-through' configuration.
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore passivation(Boolean value) {
		this.passivation = value;
		return (RemoteStore) this;
	}

	/**
	 * If true, when the cache starts, data stored in the cache store will be pre-loaded into memory. This is particularly useful when data in the cache store will be needed immediately after startup and you want to avoid cache operations being delayed as a result of loading this data lazily. Can be used to provide a 'warm-cache' on startup, however there is a performance penalty as startup time is affected by this process.
	 */
	@ModelNodeBinding(detypedName = "preload")
	public Boolean preload() {
		return this.preload;
	}

	/**
	 * If true, when the cache starts, data stored in the cache store will be pre-loaded into memory. This is particularly useful when data in the cache store will be needed immediately after startup and you want to avoid cache operations being delayed as a result of loading this data lazily. Can be used to provide a 'warm-cache' on startup, however there is a performance penalty as startup time is affected by this process.
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore preload(Boolean value) {
		this.preload = value;
		return (RemoteStore) this;
	}

	/**
	 * A list of cache store properties.
	 */
	@ModelNodeBinding(detypedName = "properties")
	public Map properties() {
		return this.properties;
	}

	/**
	 * A list of cache store properties.
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore properties(Map value) {
		this.properties = value;
		return (RemoteStore) this;
	}

	/**
	 * If true, purges this cache store when it starts up.
	 */
	@ModelNodeBinding(detypedName = "purge")
	public Boolean purge() {
		return this.purge;
	}

	/**
	 * If true, purges this cache store when it starts up.
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore purge(Boolean value) {
		this.purge = value;
		return (RemoteStore) this;
	}

	/**
	 * A list of remote servers for this cache store.
	 */
	@ModelNodeBinding(detypedName = "remote-servers")
	public List<String> remoteServers() {
		return this.remoteServers;
	}

	/**
	 * A list of remote servers for this cache store.
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore remoteServers(List<String> value) {
		this.remoteServers = value;
		return (RemoteStore) this;
	}

	/**
	 * This setting should be set to true when multiple cache instances share the same cache store (e.g., multiple nodes in a cluster using a JDBC-based CacheStore pointing to the same, shared database.) Setting this to true avoids multiple cache instances writing the same modification multiple times. If enabled, only the node where the modification originated will write to the cache store. If disabled, each individual cache reacts to a potential remote update by storing the data to the cache store.
	 */
	@ModelNodeBinding(detypedName = "shared")
	public Boolean shared() {
		return this.shared;
	}

	/**
	 * This setting should be set to true when multiple cache instances share the same cache store (e.g., multiple nodes in a cluster using a JDBC-based CacheStore pointing to the same, shared database.) Setting this to true avoids multiple cache instances writing the same modification multiple times. If enabled, only the node where the modification originated will write to the cache store. If disabled, each individual cache reacts to a potential remote update by storing the data to the cache store.
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore shared(Boolean value) {
		this.shared = value;
		return (RemoteStore) this;
	}

	/**
	 * If true, the singleton store cache store is enabled. SingletonStore is a delegating cache store used for situations when only one instance in a cluster should interact with the underlying store.
	 */
	@ModelNodeBinding(detypedName = "singleton")
	public Boolean singleton() {
		return this.singleton;
	}

	/**
	 * If true, the singleton store cache store is enabled. SingletonStore is a delegating cache store used for situations when only one instance in a cluster should interact with the underlying store.
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore singleton(Boolean value) {
		this.singleton = value;
		return (RemoteStore) this;
	}

	/**
	 * A socket timeout for remote cache communication.
	 */
	@ModelNodeBinding(detypedName = "socket-timeout")
	public Long socketTimeout() {
		return this.socketTimeout;
	}

	/**
	 * A socket timeout for remote cache communication.
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore socketTimeout(Long value) {
		this.socketTimeout = value;
		return (RemoteStore) this;
	}

	/**
	 * A TCP_NODELAY value for remote cache communication.
	 */
	@ModelNodeBinding(detypedName = "tcp-no-delay")
	public Boolean tcpNoDelay() {
		return this.tcpNoDelay;
	}

	/**
	 * A TCP_NODELAY value for remote cache communication.
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore tcpNoDelay(Boolean value) {
		this.tcpNoDelay = value;
		return (RemoteStore) this;
	}

	public RemoteStoreResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.infinispan.cache_container.Property objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.infinispan.cache_container.Property objects.
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore propertys(
			List<org.wildfly.swarm.config.infinispan.cache_container.Property> value) {
		this.subresources.propertys.addAll(value);
		return (RemoteStore) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.infinispan.cache_container.Property object to the list of subresources
	 * @param value The org.wildfly.swarm.config.infinispan.cache_container.Property to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore property(Property value) {
		this.subresources.propertys.add(value);
		return (RemoteStore) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.infinispan.cache_container.Property object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.infinispan.cache_container.Property resource
	 * @param config The org.wildfly.swarm.config.infinispan.cache_container.PropertyConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore property(String childKey, PropertyConfigurator config) {
		org.wildfly.swarm.config.infinispan.cache_container.Property child = new org.wildfly.swarm.config.infinispan.cache_container.Property(
				childKey);
		config.configure(child);
		property(child);
		return (RemoteStore) this;
	}

	/**
	 * Child mutators for RemoteStore
	 */
	public class RemoteStoreResources {
		/**
		 * A cache store property with name and value.
		 */
		private List<org.wildfly.swarm.config.infinispan.cache_container.Property> propertys = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.infinispan.cache_container.Property resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Property> propertys() {
			return this.propertys;
		}
	}

	/**
	 * Configures a cache store as write-through.
	 */
	@Subresource
	public ThroughWrite throughWrite() {
		return this.throughWrite;
	}

	/**
	 * Configures a cache store as write-through.
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore throughWrite(ThroughWrite value) {
		this.throughWrite = value;
		return (RemoteStore) this;
	}

	/**
	 * Configures a cache store as write-behind instead of write-through.
	 */
	@Subresource
	public BehindWrite behindWrite() {
		return this.behindWrite;
	}

	/**
	 * Configures a cache store as write-behind instead of write-through.
	 */
	@SuppressWarnings("unchecked")
	public RemoteStore behindWrite(BehindWrite value) {
		this.behindWrite = value;
		return (RemoteStore) this;
	}
}