package org.wildfly.swarm.config.security.security_domain;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModule;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleConfigurator;
/**
 * Traditional authentication configuration.  Configures a list of login modules to be used.
 */
@ResourceType("authentication")
@Implicit
public class ClassicAuthentication<T extends ClassicAuthentication> {

	private String key;
	private ClassicAuthenticationResources subresources = new ClassicAuthenticationResources();

	public ClassicAuthentication() {
		this.key = "classic";
	}

	public String getKey() {
		return this.key;
	}

	public ClassicAuthenticationResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.security.security_domain.authentication.LoginModule objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.security.security_domain.authentication.LoginModule objects.
	 */
	@SuppressWarnings("unchecked")
	public ClassicAuthentication loginModules(
			List<org.wildfly.swarm.config.security.security_domain.authentication.LoginModule> value) {
		this.subresources.loginModules.addAll(value);
		return (ClassicAuthentication) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.security.security_domain.authentication.LoginModule object to the list of subresources
	 * @param value The org.wildfly.swarm.config.security.security_domain.authentication.LoginModule to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicAuthentication loginModule(LoginModule value) {
		this.subresources.loginModules.add(value);
		return (ClassicAuthentication) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.security.security_domain.authentication.LoginModule object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.security.security_domain.authentication.LoginModule resource
	 * @param config The org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public ClassicAuthentication loginModule(String childKey,
			LoginModuleConfigurator config) {
		org.wildfly.swarm.config.security.security_domain.authentication.LoginModule child = new org.wildfly.swarm.config.security.security_domain.authentication.LoginModule(
				childKey);
		config.configure(child);
		loginModule(child);
		return (ClassicAuthentication) this;
	}

	/**
	 * Child mutators for ClassicAuthentication
	 */
	public class ClassicAuthenticationResources {
		/**
		 * List of authentication modules
		 */
		private List<org.wildfly.swarm.config.security.security_domain.authentication.LoginModule> loginModules = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.security.security_domain.authentication.LoginModule resources
		 * @return the list of resources
		 */
		@Subresource
		public List<LoginModule> loginModules() {
			return this.loginModules;
		}
	}
}