package org.wildfly.swarm.config.transactions.log_store;

import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.transactions.log_store.transactions.Participants;
import org.wildfly.swarm.config.transactions.log_store.transactions.ParticipantsConfigurator;
/**
 * The persistent information that the transaction manager stores for the purpose of recovering a transaction in the event of failure. The probe operation will add and remove transactions from the model as the corresponding real transactions start and finish the prepare and commit phases. A stuck transaction will remain in the model until either it is completed or explicitly removed by the delete operation.
 */
@ResourceType("transactions")
public class Transactions<T extends Transactions> {

	private String key;
	private Long ageInSeconds;
	private String id;
	private String jmxName;
	private String type;
	private TransactionsResources subresources = new TransactionsResources();

	public Transactions(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * The time since this transaction was prepared or when the recovery system last tried to recover it.
	 */
	@ModelNodeBinding(detypedName = "age-in-seconds")
	public Long ageInSeconds() {
		return this.ageInSeconds;
	}

	/**
	 * The time since this transaction was prepared or when the recovery system last tried to recover it.
	 */
	@SuppressWarnings("unchecked")
	public Transactions ageInSeconds(Long value) {
		this.ageInSeconds = value;
		return (Transactions) this;
	}

	/**
	 * The id of this transaction.
	 */
	@ModelNodeBinding(detypedName = "id")
	public String id() {
		return this.id;
	}

	/**
	 * The id of this transaction.
	 */
	@SuppressWarnings("unchecked")
	public Transactions id(String value) {
		this.id = value;
		return (Transactions) this;
	}

	/**
	 * The JMX name of this transaction.
	 */
	@ModelNodeBinding(detypedName = "jmx-name")
	public String jmxName() {
		return this.jmxName;
	}

	/**
	 * The JMX name of this transaction.
	 */
	@SuppressWarnings("unchecked")
	public Transactions jmxName(String value) {
		this.jmxName = value;
		return (Transactions) this;
	}

	/**
	 * The type name under which this record is stored.
	 */
	@ModelNodeBinding(detypedName = "type")
	public String type() {
		return this.type;
	}

	/**
	 * The type name under which this record is stored.
	 */
	@SuppressWarnings("unchecked")
	public Transactions type(String value) {
		this.type = value;
		return (Transactions) this;
	}

	public TransactionsResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all org.wildfly.swarm.config.transactions.log_store.transactions.Participants objects to this subresource
	 * @return this
	 * @param value List of org.wildfly.swarm.config.transactions.log_store.transactions.Participants objects.
	 */
	@SuppressWarnings("unchecked")
	public Transactions participants(
			List<org.wildfly.swarm.config.transactions.log_store.transactions.Participants> value) {
		this.subresources.participants.addAll(value);
		return (Transactions) this;
	}

	/**
	 * Add the org.wildfly.swarm.config.transactions.log_store.transactions.Participants object to the list of subresources
	 * @param value The org.wildfly.swarm.config.transactions.log_store.transactions.Participants to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Transactions participants(Participants value) {
		this.subresources.participants.add(value);
		return (Transactions) this;
	}

	/**
	 * Create and configure a org.wildfly.swarm.config.transactions.log_store.transactions.Participants object to the list of subresources
	 * @param key The key for the org.wildfly.swarm.config.transactions.log_store.transactions.Participants resource
	 * @param config The org.wildfly.swarm.config.transactions.log_store.transactions.ParticipantsConfigurator to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public Transactions participants(String childKey,
			ParticipantsConfigurator config) {
		org.wildfly.swarm.config.transactions.log_store.transactions.Participants child = new org.wildfly.swarm.config.transactions.log_store.transactions.Participants(
				childKey);
		config.configure(child);
		participants(child);
		return (Transactions) this;
	}

	/**
	 * Child mutators for Transactions
	 */
	public class TransactionsResources {
		/**
		 * The resources that did work in a transaction.
		 */
		private List<org.wildfly.swarm.config.transactions.log_store.transactions.Participants> participants = new java.util.ArrayList<>();

		/**
		 * Get the list of org.wildfly.swarm.config.transactions.log_store.transactions.Participants resources
		 * @return the list of resources
		 */
		@Subresource
		public List<Participants> participants() {
			return this.participants;
		}
	}
}