/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.jca.ArchiveValidation;
import org.wildfly.swarm.config.jca.BeanValidation;
import org.wildfly.swarm.config.jca.BootstrapContext;
import org.wildfly.swarm.config.jca.BootstrapContextConfigurator;
import org.wildfly.swarm.config.jca.CachedConnectionManager;
import org.wildfly.swarm.config.jca.DistributedWorkmanager;
import org.wildfly.swarm.config.jca.DistributedWorkmanagerConfigurator;
import org.wildfly.swarm.config.jca.Tracer;
import org.wildfly.swarm.config.jca.Workmanager;
import org.wildfly.swarm.config.jca.WorkmanagerConfigurator;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@ResourceType(value="subsystem")
@Implicit
public class Jca<T extends Jca> {
    private String key = "jca";
    private JcaResources subresources = new JcaResources();
    private CachedConnectionManager cachedConnectionManager;
    private BeanValidation beanValidation;
    private Tracer tracer;
    private ArchiveValidation archiveValidation;

    public String getKey() {
        return this.key;
    }

    public JcaResources subresources() {
        return this.subresources;
    }

    public T distributedWorkmanagers(List<DistributedWorkmanager> value) {
        this.subresources.distributedWorkmanagers.addAll(value);
        return (T)this;
    }

    public T distributedWorkmanager(DistributedWorkmanager value) {
        this.subresources.distributedWorkmanagers.add(value);
        return (T)this;
    }

    public T distributedWorkmanager(String childKey, DistributedWorkmanagerConfigurator config) {
        DistributedWorkmanager child = new DistributedWorkmanager(childKey);
        config.configure(child);
        this.distributedWorkmanager(child);
        return (T)this;
    }

    public T workmanagers(List<Workmanager> value) {
        this.subresources.workmanagers.addAll(value);
        return (T)this;
    }

    public T workmanager(Workmanager value) {
        this.subresources.workmanagers.add(value);
        return (T)this;
    }

    public T workmanager(String childKey, WorkmanagerConfigurator config) {
        Workmanager child = new Workmanager(childKey);
        config.configure(child);
        this.workmanager(child);
        return (T)this;
    }

    public T bootstrapContexts(List<BootstrapContext> value) {
        this.subresources.bootstrapContexts.addAll(value);
        return (T)this;
    }

    public T bootstrapContext(BootstrapContext value) {
        this.subresources.bootstrapContexts.add(value);
        return (T)this;
    }

    public T bootstrapContext(String childKey, BootstrapContextConfigurator config) {
        BootstrapContext child = new BootstrapContext(childKey);
        config.configure(child);
        this.bootstrapContext(child);
        return (T)this;
    }

    @Subresource
    public CachedConnectionManager cachedConnectionManager() {
        return this.cachedConnectionManager;
    }

    public T cachedConnectionManager(CachedConnectionManager value) {
        this.cachedConnectionManager = value;
        return (T)this;
    }

    @Subresource
    public BeanValidation beanValidation() {
        return this.beanValidation;
    }

    public T beanValidation(BeanValidation value) {
        this.beanValidation = value;
        return (T)this;
    }

    @Subresource
    public Tracer tracer() {
        return this.tracer;
    }

    public T tracer(Tracer value) {
        this.tracer = value;
        return (T)this;
    }

    @Subresource
    public ArchiveValidation archiveValidation() {
        return this.archiveValidation;
    }

    public T archiveValidation(ArchiveValidation value) {
        this.archiveValidation = value;
        return (T)this;
    }

    public class JcaResources {
        private List<DistributedWorkmanager> distributedWorkmanagers = new ArrayList<DistributedWorkmanager>();
        private List<Workmanager> workmanagers = new ArrayList<Workmanager>();
        private List<BootstrapContext> bootstrapContexts = new ArrayList<BootstrapContext>();

        @Subresource
        public List<DistributedWorkmanager> distributedWorkmanagers() {
            return this.distributedWorkmanagers;
        }

        @Subresource
        public List<Workmanager> workmanagers() {
            return this.workmanagers;
        }

        @Subresource
        public List<BootstrapContext> bootstrapContexts() {
            return this.bootstrapContexts;
        }
    }
}

