/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.logging.AsyncHandler;
import org.wildfly.swarm.config.logging.AsyncHandlerConfigurator;
import org.wildfly.swarm.config.logging.ConsoleHandler;
import org.wildfly.swarm.config.logging.ConsoleHandlerConfigurator;
import org.wildfly.swarm.config.logging.CustomFormatter;
import org.wildfly.swarm.config.logging.CustomFormatterConfigurator;
import org.wildfly.swarm.config.logging.CustomHandler;
import org.wildfly.swarm.config.logging.CustomHandlerConfigurator;
import org.wildfly.swarm.config.logging.FileHandler;
import org.wildfly.swarm.config.logging.FileHandlerConfigurator;
import org.wildfly.swarm.config.logging.LogFile;
import org.wildfly.swarm.config.logging.LogFileConfigurator;
import org.wildfly.swarm.config.logging.Logger;
import org.wildfly.swarm.config.logging.LoggerConfigurator;
import org.wildfly.swarm.config.logging.LoggingProfile;
import org.wildfly.swarm.config.logging.LoggingProfileConfigurator;
import org.wildfly.swarm.config.logging.PatternFormatter;
import org.wildfly.swarm.config.logging.PatternFormatterConfigurator;
import org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler;
import org.wildfly.swarm.config.logging.PeriodicRotatingFileHandlerConfigurator;
import org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler;
import org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandlerConfigurator;
import org.wildfly.swarm.config.logging.RootLogger;
import org.wildfly.swarm.config.logging.SizeRotatingFileHandler;
import org.wildfly.swarm.config.logging.SizeRotatingFileHandlerConfigurator;
import org.wildfly.swarm.config.logging.SyslogHandler;
import org.wildfly.swarm.config.logging.SyslogHandlerConfigurator;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@ResourceType(value="subsystem")
@Implicit
public class Logging<T extends Logging> {
    private String key = "logging";
    private Boolean addLoggingApiDependencies;
    private Boolean useDeploymentLoggingConfig;
    private LoggingResources subresources = new LoggingResources();
    private RootLogger rootLogger;

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="add-logging-api-dependencies")
    public Boolean addLoggingApiDependencies() {
        return this.addLoggingApiDependencies;
    }

    public T addLoggingApiDependencies(Boolean value) {
        this.addLoggingApiDependencies = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="use-deployment-logging-config")
    public Boolean useDeploymentLoggingConfig() {
        return this.useDeploymentLoggingConfig;
    }

    public T useDeploymentLoggingConfig(Boolean value) {
        this.useDeploymentLoggingConfig = value;
        return (T)this;
    }

    public LoggingResources subresources() {
        return this.subresources;
    }

    public T periodicRotatingFileHandlers(List<PeriodicRotatingFileHandler> value) {
        this.subresources.periodicRotatingFileHandlers.addAll(value);
        return (T)this;
    }

    public T periodicRotatingFileHandler(PeriodicRotatingFileHandler value) {
        this.subresources.periodicRotatingFileHandlers.add(value);
        return (T)this;
    }

    public T periodicRotatingFileHandler(String childKey, PeriodicRotatingFileHandlerConfigurator config) {
        PeriodicRotatingFileHandler child = new PeriodicRotatingFileHandler(childKey);
        config.configure(child);
        this.periodicRotatingFileHandler(child);
        return (T)this;
    }

    public T loggers(List<Logger> value) {
        this.subresources.loggers.addAll(value);
        return (T)this;
    }

    public T logger(Logger value) {
        this.subresources.loggers.add(value);
        return (T)this;
    }

    public T logger(String childKey, LoggerConfigurator config) {
        Logger child = new Logger(childKey);
        config.configure(child);
        this.logger(child);
        return (T)this;
    }

    public T asyncHandlers(List<AsyncHandler> value) {
        this.subresources.asyncHandlers.addAll(value);
        return (T)this;
    }

    public T asyncHandler(AsyncHandler value) {
        this.subresources.asyncHandlers.add(value);
        return (T)this;
    }

    public T asyncHandler(String childKey, AsyncHandlerConfigurator config) {
        AsyncHandler child = new AsyncHandler(childKey);
        config.configure(child);
        this.asyncHandler(child);
        return (T)this;
    }

    public T fileHandlers(List<FileHandler> value) {
        this.subresources.fileHandlers.addAll(value);
        return (T)this;
    }

    public T fileHandler(FileHandler value) {
        this.subresources.fileHandlers.add(value);
        return (T)this;
    }

    public T fileHandler(String childKey, FileHandlerConfigurator config) {
        FileHandler child = new FileHandler(childKey);
        config.configure(child);
        this.fileHandler(child);
        return (T)this;
    }

    public T sizeRotatingFileHandlers(List<SizeRotatingFileHandler> value) {
        this.subresources.sizeRotatingFileHandlers.addAll(value);
        return (T)this;
    }

    public T sizeRotatingFileHandler(SizeRotatingFileHandler value) {
        this.subresources.sizeRotatingFileHandlers.add(value);
        return (T)this;
    }

    public T sizeRotatingFileHandler(String childKey, SizeRotatingFileHandlerConfigurator config) {
        SizeRotatingFileHandler child = new SizeRotatingFileHandler(childKey);
        config.configure(child);
        this.sizeRotatingFileHandler(child);
        return (T)this;
    }

    public T syslogHandlers(List<SyslogHandler> value) {
        this.subresources.syslogHandlers.addAll(value);
        return (T)this;
    }

    public T syslogHandler(SyslogHandler value) {
        this.subresources.syslogHandlers.add(value);
        return (T)this;
    }

    public T syslogHandler(String childKey, SyslogHandlerConfigurator config) {
        SyslogHandler child = new SyslogHandler(childKey);
        config.configure(child);
        this.syslogHandler(child);
        return (T)this;
    }

    public T loggingProfiles(List<LoggingProfile> value) {
        this.subresources.loggingProfiles.addAll(value);
        return (T)this;
    }

    public T loggingProfile(LoggingProfile value) {
        this.subresources.loggingProfiles.add(value);
        return (T)this;
    }

    public T loggingProfile(String childKey, LoggingProfileConfigurator config) {
        LoggingProfile child = new LoggingProfile(childKey);
        config.configure(child);
        this.loggingProfile(child);
        return (T)this;
    }

    public T customFormatters(List<CustomFormatter> value) {
        this.subresources.customFormatters.addAll(value);
        return (T)this;
    }

    public T customFormatter(CustomFormatter value) {
        this.subresources.customFormatters.add(value);
        return (T)this;
    }

    public T customFormatter(String childKey, CustomFormatterConfigurator config) {
        CustomFormatter child = new CustomFormatter(childKey);
        config.configure(child);
        this.customFormatter(child);
        return (T)this;
    }

    public T periodicSizeRotatingFileHandlers(List<PeriodicSizeRotatingFileHandler> value) {
        this.subresources.periodicSizeRotatingFileHandlers.addAll(value);
        return (T)this;
    }

    public T periodicSizeRotatingFileHandler(PeriodicSizeRotatingFileHandler value) {
        this.subresources.periodicSizeRotatingFileHandlers.add(value);
        return (T)this;
    }

    public T periodicSizeRotatingFileHandler(String childKey, PeriodicSizeRotatingFileHandlerConfigurator config) {
        PeriodicSizeRotatingFileHandler child = new PeriodicSizeRotatingFileHandler(childKey);
        config.configure(child);
        this.periodicSizeRotatingFileHandler(child);
        return (T)this;
    }

    public T consoleHandlers(List<ConsoleHandler> value) {
        this.subresources.consoleHandlers.addAll(value);
        return (T)this;
    }

    public T consoleHandler(ConsoleHandler value) {
        this.subresources.consoleHandlers.add(value);
        return (T)this;
    }

    public T consoleHandler(String childKey, ConsoleHandlerConfigurator config) {
        ConsoleHandler child = new ConsoleHandler(childKey);
        config.configure(child);
        this.consoleHandler(child);
        return (T)this;
    }

    public T logFiles(List<LogFile> value) {
        this.subresources.logFiles.addAll(value);
        return (T)this;
    }

    public T logFile(LogFile value) {
        this.subresources.logFiles.add(value);
        return (T)this;
    }

    public T logFile(String childKey, LogFileConfigurator config) {
        LogFile child = new LogFile(childKey);
        config.configure(child);
        this.logFile(child);
        return (T)this;
    }

    public T patternFormatters(List<PatternFormatter> value) {
        this.subresources.patternFormatters.addAll(value);
        return (T)this;
    }

    public T patternFormatter(PatternFormatter value) {
        this.subresources.patternFormatters.add(value);
        return (T)this;
    }

    public T patternFormatter(String childKey, PatternFormatterConfigurator config) {
        PatternFormatter child = new PatternFormatter(childKey);
        config.configure(child);
        this.patternFormatter(child);
        return (T)this;
    }

    public T customHandlers(List<CustomHandler> value) {
        this.subresources.customHandlers.addAll(value);
        return (T)this;
    }

    public T customHandler(CustomHandler value) {
        this.subresources.customHandlers.add(value);
        return (T)this;
    }

    public T customHandler(String childKey, CustomHandlerConfigurator config) {
        CustomHandler child = new CustomHandler(childKey);
        config.configure(child);
        this.customHandler(child);
        return (T)this;
    }

    @Subresource
    public RootLogger rootLogger() {
        return this.rootLogger;
    }

    public T rootLogger(RootLogger value) {
        this.rootLogger = value;
        return (T)this;
    }

    public class LoggingResources {
        private List<PeriodicRotatingFileHandler> periodicRotatingFileHandlers = new ArrayList<PeriodicRotatingFileHandler>();
        private List<Logger> loggers = new ArrayList<Logger>();
        private List<AsyncHandler> asyncHandlers = new ArrayList<AsyncHandler>();
        private List<FileHandler> fileHandlers = new ArrayList<FileHandler>();
        private List<SizeRotatingFileHandler> sizeRotatingFileHandlers = new ArrayList<SizeRotatingFileHandler>();
        private List<SyslogHandler> syslogHandlers = new ArrayList<SyslogHandler>();
        private List<LoggingProfile> loggingProfiles = new ArrayList<LoggingProfile>();
        private List<CustomFormatter> customFormatters = new ArrayList<CustomFormatter>();
        private List<PeriodicSizeRotatingFileHandler> periodicSizeRotatingFileHandlers = new ArrayList<PeriodicSizeRotatingFileHandler>();
        private List<ConsoleHandler> consoleHandlers = new ArrayList<ConsoleHandler>();
        private List<LogFile> logFiles = new ArrayList<LogFile>();
        private List<PatternFormatter> patternFormatters = new ArrayList<PatternFormatter>();
        private List<CustomHandler> customHandlers = new ArrayList<CustomHandler>();

        @Subresource
        public List<PeriodicRotatingFileHandler> periodicRotatingFileHandlers() {
            return this.periodicRotatingFileHandlers;
        }

        @Subresource
        public List<Logger> loggers() {
            return this.loggers;
        }

        @Subresource
        public List<AsyncHandler> asyncHandlers() {
            return this.asyncHandlers;
        }

        @Subresource
        public List<FileHandler> fileHandlers() {
            return this.fileHandlers;
        }

        @Subresource
        public List<SizeRotatingFileHandler> sizeRotatingFileHandlers() {
            return this.sizeRotatingFileHandlers;
        }

        @Subresource
        public List<SyslogHandler> syslogHandlers() {
            return this.syslogHandlers;
        }

        @Subresource
        public List<LoggingProfile> loggingProfiles() {
            return this.loggingProfiles;
        }

        @Subresource
        public List<CustomFormatter> customFormatters() {
            return this.customFormatters;
        }

        @Subresource
        public List<PeriodicSizeRotatingFileHandler> periodicSizeRotatingFileHandlers() {
            return this.periodicSizeRotatingFileHandlers;
        }

        @Subresource
        public List<ConsoleHandler> consoleHandlers() {
            return this.consoleHandlers;
        }

        @Subresource
        public List<LogFile> logFiles() {
            return this.logFiles;
        }

        @Subresource
        public List<PatternFormatter> patternFormatters() {
            return this.patternFormatters;
        }

        @Subresource
        public List<CustomHandler> customHandlers() {
            return this.customHandlers;
        }
    }
}

