/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.remoting.Connector;
import org.wildfly.swarm.config.remoting.ConnectorConfigurator;
import org.wildfly.swarm.config.remoting.EndpointConfiguration;
import org.wildfly.swarm.config.remoting.HttpConnector;
import org.wildfly.swarm.config.remoting.HttpConnectorConfigurator;
import org.wildfly.swarm.config.remoting.LocalOutboundConnection;
import org.wildfly.swarm.config.remoting.LocalOutboundConnectionConfigurator;
import org.wildfly.swarm.config.remoting.OutboundConnection;
import org.wildfly.swarm.config.remoting.OutboundConnectionConfigurator;
import org.wildfly.swarm.config.remoting.RemoteOutboundConnection;
import org.wildfly.swarm.config.remoting.RemoteOutboundConnectionConfigurator;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@ResourceType(value="subsystem")
@Implicit
public class Remoting<T extends Remoting> {
    private String key = "remoting";
    private RemotingResources subresources = new RemotingResources();
    private EndpointConfiguration endpointConfiguration;

    public String getKey() {
        return this.key;
    }

    public RemotingResources subresources() {
        return this.subresources;
    }

    public T httpConnectors(List<HttpConnector> value) {
        this.subresources.httpConnectors.addAll(value);
        return (T)this;
    }

    public T httpConnector(HttpConnector value) {
        this.subresources.httpConnectors.add(value);
        return (T)this;
    }

    public T httpConnector(String childKey, HttpConnectorConfigurator config) {
        HttpConnector child = new HttpConnector(childKey);
        config.configure(child);
        this.httpConnector(child);
        return (T)this;
    }

    public T connectors(List<Connector> value) {
        this.subresources.connectors.addAll(value);
        return (T)this;
    }

    public T connector(Connector value) {
        this.subresources.connectors.add(value);
        return (T)this;
    }

    public T connector(String childKey, ConnectorConfigurator config) {
        Connector child = new Connector(childKey);
        config.configure(child);
        this.connector(child);
        return (T)this;
    }

    public T outboundConnections(List<OutboundConnection> value) {
        this.subresources.outboundConnections.addAll(value);
        return (T)this;
    }

    public T outboundConnection(OutboundConnection value) {
        this.subresources.outboundConnections.add(value);
        return (T)this;
    }

    public T outboundConnection(String childKey, OutboundConnectionConfigurator config) {
        OutboundConnection child = new OutboundConnection(childKey);
        config.configure(child);
        this.outboundConnection(child);
        return (T)this;
    }

    public T localOutboundConnections(List<LocalOutboundConnection> value) {
        this.subresources.localOutboundConnections.addAll(value);
        return (T)this;
    }

    public T localOutboundConnection(LocalOutboundConnection value) {
        this.subresources.localOutboundConnections.add(value);
        return (T)this;
    }

    public T localOutboundConnection(String childKey, LocalOutboundConnectionConfigurator config) {
        LocalOutboundConnection child = new LocalOutboundConnection(childKey);
        config.configure(child);
        this.localOutboundConnection(child);
        return (T)this;
    }

    public T remoteOutboundConnections(List<RemoteOutboundConnection> value) {
        this.subresources.remoteOutboundConnections.addAll(value);
        return (T)this;
    }

    public T remoteOutboundConnection(RemoteOutboundConnection value) {
        this.subresources.remoteOutboundConnections.add(value);
        return (T)this;
    }

    public T remoteOutboundConnection(String childKey, RemoteOutboundConnectionConfigurator config) {
        RemoteOutboundConnection child = new RemoteOutboundConnection(childKey);
        config.configure(child);
        this.remoteOutboundConnection(child);
        return (T)this;
    }

    @Subresource
    public EndpointConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    public T endpointConfiguration(EndpointConfiguration value) {
        this.endpointConfiguration = value;
        return (T)this;
    }

    public class RemotingResources {
        private List<HttpConnector> httpConnectors = new ArrayList<HttpConnector>();
        private List<Connector> connectors = new ArrayList<Connector>();
        private List<OutboundConnection> outboundConnections = new ArrayList<OutboundConnection>();
        private List<LocalOutboundConnection> localOutboundConnections = new ArrayList<LocalOutboundConnection>();
        private List<RemoteOutboundConnection> remoteOutboundConnections = new ArrayList<RemoteOutboundConnection>();

        @Subresource
        public List<HttpConnector> httpConnectors() {
            return this.httpConnectors;
        }

        @Subresource
        public List<Connector> connectors() {
            return this.connectors;
        }

        @Subresource
        public List<OutboundConnection> outboundConnections() {
            return this.outboundConnections;
        }

        @Subresource
        public List<LocalOutboundConnection> localOutboundConnections() {
            return this.localOutboundConnections;
        }

        @Subresource
        public List<RemoteOutboundConnection> remoteOutboundConnections() {
            return this.remoteOutboundConnections;
        }
    }
}

