/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.BufferCache;
import org.wildfly.swarm.config.undertow.BufferCacheConfigurator;
import org.wildfly.swarm.config.undertow.FilterConfiguration;
import org.wildfly.swarm.config.undertow.HandlerConfiguration;
import org.wildfly.swarm.config.undertow.Server;
import org.wildfly.swarm.config.undertow.ServerConfigurator;
import org.wildfly.swarm.config.undertow.ServletContainer;
import org.wildfly.swarm.config.undertow.ServletContainerConfigurator;

@ResourceType(value="subsystem")
@Implicit
public class Undertow<T extends Undertow> {
    private String key = "undertow";
    private String defaultServer;
    private String defaultServletContainer;
    private String defaultVirtualHost;
    private String instanceId;
    private Boolean statisticsEnabled;
    private UndertowResources subresources = new UndertowResources();
    private HandlerConfiguration handlerConfiguration;
    private FilterConfiguration filterConfiguration;

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="default-server")
    public String defaultServer() {
        return this.defaultServer;
    }

    public T defaultServer(String value) {
        this.defaultServer = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-servlet-container")
    public String defaultServletContainer() {
        return this.defaultServletContainer;
    }

    public T defaultServletContainer(String value) {
        this.defaultServletContainer = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="default-virtual-host")
    public String defaultVirtualHost() {
        return this.defaultVirtualHost;
    }

    public T defaultVirtualHost(String value) {
        this.defaultVirtualHost = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="instance-id")
    public String instanceId() {
        return this.instanceId;
    }

    public T instanceId(String value) {
        this.instanceId = value;
        return (T)this;
    }

    @ModelNodeBinding(detypedName="statistics-enabled")
    public Boolean statisticsEnabled() {
        return this.statisticsEnabled;
    }

    public T statisticsEnabled(Boolean value) {
        this.statisticsEnabled = value;
        return (T)this;
    }

    public UndertowResources subresources() {
        return this.subresources;
    }

    public T servers(List<Server> value) {
        this.subresources.servers.addAll(value);
        return (T)this;
    }

    public T server(Server value) {
        this.subresources.servers.add(value);
        return (T)this;
    }

    public T server(String childKey, ServerConfigurator config) {
        Server child = new Server(childKey);
        config.configure(child);
        this.server(child);
        return (T)this;
    }

    public T bufferCaches(List<BufferCache> value) {
        this.subresources.bufferCaches.addAll(value);
        return (T)this;
    }

    public T bufferCache(BufferCache value) {
        this.subresources.bufferCaches.add(value);
        return (T)this;
    }

    public T bufferCache(String childKey, BufferCacheConfigurator config) {
        BufferCache child = new BufferCache(childKey);
        config.configure(child);
        this.bufferCache(child);
        return (T)this;
    }

    public T servletContainers(List<ServletContainer> value) {
        this.subresources.servletContainers.addAll(value);
        return (T)this;
    }

    public T servletContainer(ServletContainer value) {
        this.subresources.servletContainers.add(value);
        return (T)this;
    }

    public T servletContainer(String childKey, ServletContainerConfigurator config) {
        ServletContainer child = new ServletContainer(childKey);
        config.configure(child);
        this.servletContainer(child);
        return (T)this;
    }

    @Subresource
    public HandlerConfiguration handlerConfiguration() {
        return this.handlerConfiguration;
    }

    public T handlerConfiguration(HandlerConfiguration value) {
        this.handlerConfiguration = value;
        return (T)this;
    }

    @Subresource
    public FilterConfiguration filterConfiguration() {
        return this.filterConfiguration;
    }

    public T filterConfiguration(FilterConfiguration value) {
        this.filterConfiguration = value;
        return (T)this;
    }

    public class UndertowResources {
        private List<Server> servers = new ArrayList<Server>();
        private List<BufferCache> bufferCaches = new ArrayList<BufferCache>();
        private List<ServletContainer> servletContainers = new ArrayList<ServletContainer>();

        @Subresource
        public List<Server> servers() {
            return this.servers;
        }

        @Subresource
        public List<BufferCache> bufferCaches() {
            return this.bufferCaches;
        }

        @Subresource
        public List<ServletContainer> servletContainers() {
            return this.servletContainers;
        }
    }
}

