/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.logging;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.logging.AsyncHandler;
import org.wildfly.swarm.config.logging.AsyncHandlerConfigurator;
import org.wildfly.swarm.config.logging.ConsoleHandler;
import org.wildfly.swarm.config.logging.ConsoleHandlerConfigurator;
import org.wildfly.swarm.config.logging.CustomFormatter;
import org.wildfly.swarm.config.logging.CustomFormatterConfigurator;
import org.wildfly.swarm.config.logging.CustomHandler;
import org.wildfly.swarm.config.logging.CustomHandlerConfigurator;
import org.wildfly.swarm.config.logging.FileHandler;
import org.wildfly.swarm.config.logging.FileHandlerConfigurator;
import org.wildfly.swarm.config.logging.LogFile;
import org.wildfly.swarm.config.logging.LogFileConfigurator;
import org.wildfly.swarm.config.logging.Logger;
import org.wildfly.swarm.config.logging.LoggerConfigurator;
import org.wildfly.swarm.config.logging.PatternFormatter;
import org.wildfly.swarm.config.logging.PatternFormatterConfigurator;
import org.wildfly.swarm.config.logging.PeriodicRotatingFileHandler;
import org.wildfly.swarm.config.logging.PeriodicRotatingFileHandlerConfigurator;
import org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandler;
import org.wildfly.swarm.config.logging.PeriodicSizeRotatingFileHandlerConfigurator;
import org.wildfly.swarm.config.logging.RootLogger;
import org.wildfly.swarm.config.logging.SizeRotatingFileHandler;
import org.wildfly.swarm.config.logging.SizeRotatingFileHandlerConfigurator;
import org.wildfly.swarm.config.logging.SyslogHandler;
import org.wildfly.swarm.config.logging.SyslogHandlerConfigurator;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@ResourceType(value="logging-profile")
public class LoggingProfile<T extends LoggingProfile> {
    private String key;
    private LoggingProfileResources subresources = new LoggingProfileResources();
    private RootLogger rootLogger;

    public LoggingProfile(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public LoggingProfileResources subresources() {
        return this.subresources;
    }

    public LoggingProfile periodicRotatingFileHandlers(List<PeriodicRotatingFileHandler> value) {
        this.subresources.periodicRotatingFileHandlers.addAll(value);
        return this;
    }

    public LoggingProfile periodicRotatingFileHandler(PeriodicRotatingFileHandler value) {
        this.subresources.periodicRotatingFileHandlers.add(value);
        return this;
    }

    public LoggingProfile periodicRotatingFileHandler(String childKey, PeriodicRotatingFileHandlerConfigurator config) {
        PeriodicRotatingFileHandler child = new PeriodicRotatingFileHandler(childKey);
        config.configure(child);
        this.periodicRotatingFileHandler(child);
        return this;
    }

    public LoggingProfile customFormatters(List<CustomFormatter> value) {
        this.subresources.customFormatters.addAll(value);
        return this;
    }

    public LoggingProfile customFormatter(CustomFormatter value) {
        this.subresources.customFormatters.add(value);
        return this;
    }

    public LoggingProfile customFormatter(String childKey, CustomFormatterConfigurator config) {
        CustomFormatter child = new CustomFormatter(childKey);
        config.configure(child);
        this.customFormatter(child);
        return this;
    }

    public LoggingProfile periodicSizeRotatingFileHandlers(List<PeriodicSizeRotatingFileHandler> value) {
        this.subresources.periodicSizeRotatingFileHandlers.addAll(value);
        return this;
    }

    public LoggingProfile periodicSizeRotatingFileHandler(PeriodicSizeRotatingFileHandler value) {
        this.subresources.periodicSizeRotatingFileHandlers.add(value);
        return this;
    }

    public LoggingProfile periodicSizeRotatingFileHandler(String childKey, PeriodicSizeRotatingFileHandlerConfigurator config) {
        PeriodicSizeRotatingFileHandler child = new PeriodicSizeRotatingFileHandler(childKey);
        config.configure(child);
        this.periodicSizeRotatingFileHandler(child);
        return this;
    }

    public LoggingProfile consoleHandlers(List<ConsoleHandler> value) {
        this.subresources.consoleHandlers.addAll(value);
        return this;
    }

    public LoggingProfile consoleHandler(ConsoleHandler value) {
        this.subresources.consoleHandlers.add(value);
        return this;
    }

    public LoggingProfile consoleHandler(String childKey, ConsoleHandlerConfigurator config) {
        ConsoleHandler child = new ConsoleHandler(childKey);
        config.configure(child);
        this.consoleHandler(child);
        return this;
    }

    public LoggingProfile loggers(List<Logger> value) {
        this.subresources.loggers.addAll(value);
        return this;
    }

    public LoggingProfile logger(Logger value) {
        this.subresources.loggers.add(value);
        return this;
    }

    public LoggingProfile logger(String childKey, LoggerConfigurator config) {
        Logger child = new Logger(childKey);
        config.configure(child);
        this.logger(child);
        return this;
    }

    public LoggingProfile asyncHandlers(List<AsyncHandler> value) {
        this.subresources.asyncHandlers.addAll(value);
        return this;
    }

    public LoggingProfile asyncHandler(AsyncHandler value) {
        this.subresources.asyncHandlers.add(value);
        return this;
    }

    public LoggingProfile asyncHandler(String childKey, AsyncHandlerConfigurator config) {
        AsyncHandler child = new AsyncHandler(childKey);
        config.configure(child);
        this.asyncHandler(child);
        return this;
    }

    public LoggingProfile fileHandlers(List<FileHandler> value) {
        this.subresources.fileHandlers.addAll(value);
        return this;
    }

    public LoggingProfile fileHandler(FileHandler value) {
        this.subresources.fileHandlers.add(value);
        return this;
    }

    public LoggingProfile fileHandler(String childKey, FileHandlerConfigurator config) {
        FileHandler child = new FileHandler(childKey);
        config.configure(child);
        this.fileHandler(child);
        return this;
    }

    public LoggingProfile logFiles(List<LogFile> value) {
        this.subresources.logFiles.addAll(value);
        return this;
    }

    public LoggingProfile logFile(LogFile value) {
        this.subresources.logFiles.add(value);
        return this;
    }

    public LoggingProfile logFile(String childKey, LogFileConfigurator config) {
        LogFile child = new LogFile(childKey);
        config.configure(child);
        this.logFile(child);
        return this;
    }

    public LoggingProfile patternFormatters(List<PatternFormatter> value) {
        this.subresources.patternFormatters.addAll(value);
        return this;
    }

    public LoggingProfile patternFormatter(PatternFormatter value) {
        this.subresources.patternFormatters.add(value);
        return this;
    }

    public LoggingProfile patternFormatter(String childKey, PatternFormatterConfigurator config) {
        PatternFormatter child = new PatternFormatter(childKey);
        config.configure(child);
        this.patternFormatter(child);
        return this;
    }

    public LoggingProfile sizeRotatingFileHandlers(List<SizeRotatingFileHandler> value) {
        this.subresources.sizeRotatingFileHandlers.addAll(value);
        return this;
    }

    public LoggingProfile sizeRotatingFileHandler(SizeRotatingFileHandler value) {
        this.subresources.sizeRotatingFileHandlers.add(value);
        return this;
    }

    public LoggingProfile sizeRotatingFileHandler(String childKey, SizeRotatingFileHandlerConfigurator config) {
        SizeRotatingFileHandler child = new SizeRotatingFileHandler(childKey);
        config.configure(child);
        this.sizeRotatingFileHandler(child);
        return this;
    }

    public LoggingProfile syslogHandlers(List<SyslogHandler> value) {
        this.subresources.syslogHandlers.addAll(value);
        return this;
    }

    public LoggingProfile syslogHandler(SyslogHandler value) {
        this.subresources.syslogHandlers.add(value);
        return this;
    }

    public LoggingProfile syslogHandler(String childKey, SyslogHandlerConfigurator config) {
        SyslogHandler child = new SyslogHandler(childKey);
        config.configure(child);
        this.syslogHandler(child);
        return this;
    }

    public LoggingProfile customHandlers(List<CustomHandler> value) {
        this.subresources.customHandlers.addAll(value);
        return this;
    }

    public LoggingProfile customHandler(CustomHandler value) {
        this.subresources.customHandlers.add(value);
        return this;
    }

    public LoggingProfile customHandler(String childKey, CustomHandlerConfigurator config) {
        CustomHandler child = new CustomHandler(childKey);
        config.configure(child);
        this.customHandler(child);
        return this;
    }

    @Subresource
    public RootLogger rootLogger() {
        return this.rootLogger;
    }

    public LoggingProfile rootLogger(RootLogger value) {
        this.rootLogger = value;
        return this;
    }

    public class LoggingProfileResources {
        private List<PeriodicRotatingFileHandler> periodicRotatingFileHandlers = new ArrayList<PeriodicRotatingFileHandler>();
        private List<CustomFormatter> customFormatters = new ArrayList<CustomFormatter>();
        private List<PeriodicSizeRotatingFileHandler> periodicSizeRotatingFileHandlers = new ArrayList<PeriodicSizeRotatingFileHandler>();
        private List<ConsoleHandler> consoleHandlers = new ArrayList<ConsoleHandler>();
        private List<Logger> loggers = new ArrayList<Logger>();
        private List<AsyncHandler> asyncHandlers = new ArrayList<AsyncHandler>();
        private List<FileHandler> fileHandlers = new ArrayList<FileHandler>();
        private List<LogFile> logFiles = new ArrayList<LogFile>();
        private List<PatternFormatter> patternFormatters = new ArrayList<PatternFormatter>();
        private List<SizeRotatingFileHandler> sizeRotatingFileHandlers = new ArrayList<SizeRotatingFileHandler>();
        private List<SyslogHandler> syslogHandlers = new ArrayList<SyslogHandler>();
        private List<CustomHandler> customHandlers = new ArrayList<CustomHandler>();

        @Subresource
        public List<PeriodicRotatingFileHandler> periodicRotatingFileHandlers() {
            return this.periodicRotatingFileHandlers;
        }

        @Subresource
        public List<CustomFormatter> customFormatters() {
            return this.customFormatters;
        }

        @Subresource
        public List<PeriodicSizeRotatingFileHandler> periodicSizeRotatingFileHandlers() {
            return this.periodicSizeRotatingFileHandlers;
        }

        @Subresource
        public List<ConsoleHandler> consoleHandlers() {
            return this.consoleHandlers;
        }

        @Subresource
        public List<Logger> loggers() {
            return this.loggers;
        }

        @Subresource
        public List<AsyncHandler> asyncHandlers() {
            return this.asyncHandlers;
        }

        @Subresource
        public List<FileHandler> fileHandlers() {
            return this.fileHandlers;
        }

        @Subresource
        public List<LogFile> logFiles() {
            return this.logFiles;
        }

        @Subresource
        public List<PatternFormatter> patternFormatters() {
            return this.patternFormatters;
        }

        @Subresource
        public List<SizeRotatingFileHandler> sizeRotatingFileHandlers() {
            return this.sizeRotatingFileHandlers;
        }

        @Subresource
        public List<SyslogHandler> syslogHandlers() {
            return this.syslogHandlers;
        }

        @Subresource
        public List<CustomHandler> customHandlers() {
            return this.customHandlers;
        }
    }
}

