/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.servlet_container.JspSetting;
import org.wildfly.swarm.config.undertow.servlet_container.MimeMapping;
import org.wildfly.swarm.config.undertow.servlet_container.MimeMappingConfigurator;
import org.wildfly.swarm.config.undertow.servlet_container.PersistentSessionsSetting;
import org.wildfly.swarm.config.undertow.servlet_container.SessionCookieSetting;
import org.wildfly.swarm.config.undertow.servlet_container.WebsocketsSetting;
import org.wildfly.swarm.config.undertow.servlet_container.WelcomeFile;
import org.wildfly.swarm.config.undertow.servlet_container.WelcomeFileConfigurator;

@ResourceType(value="servlet-container")
public class ServletContainer<T extends ServletContainer> {
    private String key;
    private Boolean allowNonStandardWrappers;
    private String defaultBufferCache;
    private String defaultEncoding;
    private Integer defaultSessionTimeout;
    private Boolean directoryListing;
    private Boolean disableCachingForSecuredPages;
    private Boolean eagerFilterInitialization;
    private Boolean ignoreFlush;
    private Integer maxSessions;
    private Boolean proactiveAuthentication;
    private Integer sessionIdLength;
    private String stackTraceOnError;
    private Boolean useListenerEncoding;
    private ServletContainerResources subresources = new ServletContainerResources();
    private PersistentSessionsSetting persistentSessionsSetting;
    private JspSetting jspSetting;
    private WebsocketsSetting websocketsSetting;
    private SessionCookieSetting sessionCookieSetting;

    public ServletContainer(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="allow-non-standard-wrappers")
    public Boolean allowNonStandardWrappers() {
        return this.allowNonStandardWrappers;
    }

    public ServletContainer allowNonStandardWrappers(Boolean value) {
        this.allowNonStandardWrappers = value;
        return this;
    }

    @ModelNodeBinding(detypedName="default-buffer-cache")
    public String defaultBufferCache() {
        return this.defaultBufferCache;
    }

    public ServletContainer defaultBufferCache(String value) {
        this.defaultBufferCache = value;
        return this;
    }

    @ModelNodeBinding(detypedName="default-encoding")
    public String defaultEncoding() {
        return this.defaultEncoding;
    }

    public ServletContainer defaultEncoding(String value) {
        this.defaultEncoding = value;
        return this;
    }

    @ModelNodeBinding(detypedName="default-session-timeout")
    public Integer defaultSessionTimeout() {
        return this.defaultSessionTimeout;
    }

    public ServletContainer defaultSessionTimeout(Integer value) {
        this.defaultSessionTimeout = value;
        return this;
    }

    @ModelNodeBinding(detypedName="directory-listing")
    public Boolean directoryListing() {
        return this.directoryListing;
    }

    public ServletContainer directoryListing(Boolean value) {
        this.directoryListing = value;
        return this;
    }

    @ModelNodeBinding(detypedName="disable-caching-for-secured-pages")
    public Boolean disableCachingForSecuredPages() {
        return this.disableCachingForSecuredPages;
    }

    public ServletContainer disableCachingForSecuredPages(Boolean value) {
        this.disableCachingForSecuredPages = value;
        return this;
    }

    @ModelNodeBinding(detypedName="eager-filter-initialization")
    public Boolean eagerFilterInitialization() {
        return this.eagerFilterInitialization;
    }

    public ServletContainer eagerFilterInitialization(Boolean value) {
        this.eagerFilterInitialization = value;
        return this;
    }

    @ModelNodeBinding(detypedName="ignore-flush")
    public Boolean ignoreFlush() {
        return this.ignoreFlush;
    }

    public ServletContainer ignoreFlush(Boolean value) {
        this.ignoreFlush = value;
        return this;
    }

    @ModelNodeBinding(detypedName="max-sessions")
    public Integer maxSessions() {
        return this.maxSessions;
    }

    public ServletContainer maxSessions(Integer value) {
        this.maxSessions = value;
        return this;
    }

    @ModelNodeBinding(detypedName="proactive-authentication")
    public Boolean proactiveAuthentication() {
        return this.proactiveAuthentication;
    }

    public ServletContainer proactiveAuthentication(Boolean value) {
        this.proactiveAuthentication = value;
        return this;
    }

    @ModelNodeBinding(detypedName="session-id-length")
    public Integer sessionIdLength() {
        return this.sessionIdLength;
    }

    public ServletContainer sessionIdLength(Integer value) {
        this.sessionIdLength = value;
        return this;
    }

    @ModelNodeBinding(detypedName="stack-trace-on-error")
    public String stackTraceOnError() {
        return this.stackTraceOnError;
    }

    public ServletContainer stackTraceOnError(String value) {
        this.stackTraceOnError = value;
        return this;
    }

    @ModelNodeBinding(detypedName="use-listener-encoding")
    public Boolean useListenerEncoding() {
        return this.useListenerEncoding;
    }

    public ServletContainer useListenerEncoding(Boolean value) {
        this.useListenerEncoding = value;
        return this;
    }

    public ServletContainerResources subresources() {
        return this.subresources;
    }

    public ServletContainer mimeMappings(List<MimeMapping> value) {
        this.subresources.mimeMappings.addAll(value);
        return this;
    }

    public ServletContainer mimeMapping(MimeMapping value) {
        this.subresources.mimeMappings.add(value);
        return this;
    }

    public ServletContainer mimeMapping(String childKey, MimeMappingConfigurator config) {
        MimeMapping child = new MimeMapping(childKey);
        config.configure(child);
        this.mimeMapping(child);
        return this;
    }

    public ServletContainer welcomeFiles(List<WelcomeFile> value) {
        this.subresources.welcomeFiles.addAll(value);
        return this;
    }

    public ServletContainer welcomeFile(WelcomeFile value) {
        this.subresources.welcomeFiles.add(value);
        return this;
    }

    public ServletContainer welcomeFile(String childKey, WelcomeFileConfigurator config) {
        WelcomeFile child = new WelcomeFile(childKey);
        config.configure(child);
        this.welcomeFile(child);
        return this;
    }

    @Subresource
    public PersistentSessionsSetting persistentSessionsSetting() {
        return this.persistentSessionsSetting;
    }

    public ServletContainer persistentSessionsSetting(PersistentSessionsSetting value) {
        this.persistentSessionsSetting = value;
        return this;
    }

    @Subresource
    public JspSetting jspSetting() {
        return this.jspSetting;
    }

    public ServletContainer jspSetting(JspSetting value) {
        this.jspSetting = value;
        return this;
    }

    @Subresource
    public WebsocketsSetting websocketsSetting() {
        return this.websocketsSetting;
    }

    public ServletContainer websocketsSetting(WebsocketsSetting value) {
        this.websocketsSetting = value;
        return this;
    }

    @Subresource
    public SessionCookieSetting sessionCookieSetting() {
        return this.sessionCookieSetting;
    }

    public ServletContainer sessionCookieSetting(SessionCookieSetting value) {
        this.sessionCookieSetting = value;
        return this;
    }

    public class ServletContainerResources {
        private List<MimeMapping> mimeMappings = new ArrayList<MimeMapping>();
        private List<WelcomeFile> welcomeFiles = new ArrayList<WelcomeFile>();

        @Subresource
        public List<MimeMapping> mimeMappings() {
            return this.mimeMappings;
        }

        @Subresource
        public List<WelcomeFile> welcomeFiles() {
            return this.welcomeFiles;
        }
    }
}

