/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.configuration;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.configuration.reverse_proxy.Host;
import org.wildfly.swarm.config.undertow.configuration.reverse_proxy.HostConfigurator;

@ResourceType(value="reverse-proxy")
public class ReverseProxy<T extends ReverseProxy> {
    private String key;
    private Integer cachedConnectionsPerThread;
    private Integer connectionIdleTimeout;
    private Integer connectionsPerThread;
    private Integer maxRequestTime;
    private Integer problemServerRetry;
    private Integer requestQueueSize;
    private String sessionCookieNames;
    private ReverseProxyResources subresources = new ReverseProxyResources();

    public ReverseProxy(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="cached-connections-per-thread")
    public Integer cachedConnectionsPerThread() {
        return this.cachedConnectionsPerThread;
    }

    public ReverseProxy cachedConnectionsPerThread(Integer value) {
        this.cachedConnectionsPerThread = value;
        return this;
    }

    @ModelNodeBinding(detypedName="connection-idle-timeout")
    public Integer connectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public ReverseProxy connectionIdleTimeout(Integer value) {
        this.connectionIdleTimeout = value;
        return this;
    }

    @ModelNodeBinding(detypedName="connections-per-thread")
    public Integer connectionsPerThread() {
        return this.connectionsPerThread;
    }

    public ReverseProxy connectionsPerThread(Integer value) {
        this.connectionsPerThread = value;
        return this;
    }

    @ModelNodeBinding(detypedName="max-request-time")
    public Integer maxRequestTime() {
        return this.maxRequestTime;
    }

    public ReverseProxy maxRequestTime(Integer value) {
        this.maxRequestTime = value;
        return this;
    }

    @ModelNodeBinding(detypedName="problem-server-retry")
    public Integer problemServerRetry() {
        return this.problemServerRetry;
    }

    public ReverseProxy problemServerRetry(Integer value) {
        this.problemServerRetry = value;
        return this;
    }

    @ModelNodeBinding(detypedName="request-queue-size")
    public Integer requestQueueSize() {
        return this.requestQueueSize;
    }

    public ReverseProxy requestQueueSize(Integer value) {
        this.requestQueueSize = value;
        return this;
    }

    @ModelNodeBinding(detypedName="session-cookie-names")
    public String sessionCookieNames() {
        return this.sessionCookieNames;
    }

    public ReverseProxy sessionCookieNames(String value) {
        this.sessionCookieNames = value;
        return this;
    }

    public ReverseProxyResources subresources() {
        return this.subresources;
    }

    public ReverseProxy hosts(List<Host> value) {
        this.subresources.hosts.addAll(value);
        return this;
    }

    public ReverseProxy host(Host value) {
        this.subresources.hosts.add(value);
        return this;
    }

    public ReverseProxy host(String childKey, HostConfigurator config) {
        Host child = new Host(childKey);
        config.configure(child);
        this.host(child);
        return this;
    }

    public class ReverseProxyResources {
        private List<Host> hosts = new ArrayList<Host>();

        @Subresource
        public List<Host> hosts() {
            return this.hosts;
        }
    }
}

