/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.undertow.server;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.undertow.server.host.AccessLogSetting;
import org.wildfly.swarm.config.undertow.server.host.FilterRef;
import org.wildfly.swarm.config.undertow.server.host.FilterRefConfigurator;
import org.wildfly.swarm.config.undertow.server.host.Location;
import org.wildfly.swarm.config.undertow.server.host.LocationConfigurator;
import org.wildfly.swarm.config.undertow.server.host.SingleSignOnSetting;

@ResourceType(value="host")
public class Host<T extends Host> {
    private String key;
    private List<String> alias;
    private Integer defaultResponseCode;
    private String defaultWebModule;
    private Boolean disableConsoleRedirect;
    private HostResources subresources = new HostResources();
    private AccessLogSetting accessLogSetting;
    private SingleSignOnSetting singleSignOnSetting;

    public Host(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @ModelNodeBinding(detypedName="alias")
    public List<String> alias() {
        return this.alias;
    }

    public Host alias(List<String> value) {
        this.alias = value;
        return this;
    }

    @ModelNodeBinding(detypedName="default-response-code")
    public Integer defaultResponseCode() {
        return this.defaultResponseCode;
    }

    public Host defaultResponseCode(Integer value) {
        this.defaultResponseCode = value;
        return this;
    }

    @ModelNodeBinding(detypedName="default-web-module")
    public String defaultWebModule() {
        return this.defaultWebModule;
    }

    public Host defaultWebModule(String value) {
        this.defaultWebModule = value;
        return this;
    }

    @ModelNodeBinding(detypedName="disable-console-redirect")
    public Boolean disableConsoleRedirect() {
        return this.disableConsoleRedirect;
    }

    public Host disableConsoleRedirect(Boolean value) {
        this.disableConsoleRedirect = value;
        return this;
    }

    public HostResources subresources() {
        return this.subresources;
    }

    public Host filterRefs(List<FilterRef> value) {
        this.subresources.filterRefs.addAll(value);
        return this;
    }

    public Host filterRef(FilterRef value) {
        this.subresources.filterRefs.add(value);
        return this;
    }

    public Host filterRef(String childKey, FilterRefConfigurator config) {
        FilterRef child = new FilterRef(childKey);
        config.configure(child);
        this.filterRef(child);
        return this;
    }

    public Host locations(List<Location> value) {
        this.subresources.locations.addAll(value);
        return this;
    }

    public Host location(Location value) {
        this.subresources.locations.add(value);
        return this;
    }

    public Host location(String childKey, LocationConfigurator config) {
        Location child = new Location(childKey);
        config.configure(child);
        this.location(child);
        return this;
    }

    @Subresource
    public AccessLogSetting accessLogSetting() {
        return this.accessLogSetting;
    }

    public Host accessLogSetting(AccessLogSetting value) {
        this.accessLogSetting = value;
        return this;
    }

    @Subresource
    public SingleSignOnSetting singleSignOnSetting() {
        return this.singleSignOnSetting;
    }

    public Host singleSignOnSetting(SingleSignOnSetting value) {
        this.singleSignOnSetting = value;
        return this;
    }

    public class HostResources {
        private List<FilterRef> filterRefs = new ArrayList<FilterRef>();
        private List<Location> locations = new ArrayList<Location>();

        @Subresource
        public List<FilterRef> filterRefs() {
            return this.filterRefs;
        }

        @Subresource
        public List<Location> locations() {
            return this.locations;
        }
    }
}

