package org.wildfly.swarm.config.ee;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A context service
 */
@Address("/subsystem=ee/context-service=*")
@ResourceType("context-service")
public class ContextService<T extends ContextService<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String jndiName;
	private Boolean useTransactionSetupProvider;

	public ContextService(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The JNDI Name to lookup the context service.
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * The JNDI Name to lookup the context service.
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(String value) {
		Object oldValue = this.jndiName;
		this.jndiName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jndiName", oldValue, value);
		return (T) this;
	}

	/**
	 * Flag which indicates if the transaction setup provider should be used
	 */
	@ModelNodeBinding(detypedName = "use-transaction-setup-provider")
	public Boolean useTransactionSetupProvider() {
		return this.useTransactionSetupProvider;
	}

	/**
	 * Flag which indicates if the transaction setup provider should be used
	 */
	@SuppressWarnings("unchecked")
	public T useTransactionSetupProvider(Boolean value) {
		Object oldValue = this.useTransactionSetupProvider;
		this.useTransactionSetupProvider = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("useTransactionSetupProvider",
					oldValue, value);
		return (T) this;
	}
}