package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The EJB3 Asynchronous Invocation Service
 */
@Address("/subsystem=ejb3/service=async")
@ResourceType("service")
@Implicit
public class AsyncService<T extends AsyncService<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String threadPoolName;

	public AsyncService() {
		this.key = "async";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The name of the thread pool which handles asynchronous invocations
	 */
	@ModelNodeBinding(detypedName = "thread-pool-name")
	public String threadPoolName() {
		return this.threadPoolName;
	}

	/**
	 * The name of the thread pool which handles asynchronous invocations
	 */
	@SuppressWarnings("unchecked")
	public T threadPoolName(String value) {
		Object oldValue = this.threadPoolName;
		this.threadPoolName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("threadPoolName", oldValue, value);
		return (T) this;
	}
}