package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.ejb3.RemotingProfile;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface RemotingProfileConsumer<T extends RemotingProfile<T>> {

	/**
	 * Configure a pre-constructed instance of RemotingProfile resource
	 * 
	 * @parameter Instance of RemotingProfile to configure
	 * @return nothing
	 */
	void accept(T value);

	default RemotingProfileConsumer<T> andThen(RemotingProfileConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}