package org.wildfly.swarm.config.management;

import org.wildfly.swarm.config.management.SecurityRealm;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface SecurityRealmConsumer<T extends SecurityRealm<T>> {

	/**
	 * Configure a pre-constructed instance of SecurityRealm resource
	 * 
	 * @parameter Instance of SecurityRealm to configure
	 * @return nothing
	 */
	void accept(T value);

	default SecurityRealmConsumer<T> andThen(SecurityRealmConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}