package org.wildfly.swarm.config.management.access;

import org.wildfly.swarm.config.management.access.FileHandler;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface FileHandlerConsumer<T extends FileHandler<T>> {

	/**
	 * Configure a pre-constructed instance of FileHandler resource
	 * 
	 * @parameter Instance of FileHandler to configure
	 * @return nothing
	 */
	void accept(T value);

	default FileHandlerConsumer<T> andThen(FileHandlerConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}