package org.wildfly.swarm.config.resource.adapters.resource_adapter;

import org.wildfly.swarm.config.resource.adapters.resource_adapter.ConfigProperties;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface ConfigPropertiesConsumer<T extends ConfigProperties<T>> {

	/**
	 * Configure a pre-constructed instance of ConfigProperties resource
	 * 
	 * @parameter Instance of ConfigProperties to configure
	 * @return nothing
	 */
	void accept(T value);

	default ConfigPropertiesConsumer<T> andThen(
			ConfigPropertiesConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}