package org.wildfly.swarm.config.undertow.server.host;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The SSO configuration for this virtual server.
 */
@Address("/subsystem=undertow/server=*/host=*/setting=single-sign-on")
@ResourceType("setting")
@Implicit
public class SingleSignOnSetting<T extends SingleSignOnSetting<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String cookieName;
	private String domain;
	private Boolean httpOnly;
	private String path;
	private Boolean secure;

	public SingleSignOnSetting() {
		this.key = "single-sign-on";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Name of the cookie
	 */
	@ModelNodeBinding(detypedName = "cookie-name")
	public String cookieName() {
		return this.cookieName;
	}

	/**
	 * Name of the cookie
	 */
	@SuppressWarnings("unchecked")
	public T cookieName(String value) {
		Object oldValue = this.cookieName;
		this.cookieName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("cookieName", oldValue, value);
		return (T) this;
	}

	/**
	 * The cookie domain that will be used.
	 */
	@ModelNodeBinding(detypedName = "domain")
	public String domain() {
		return this.domain;
	}

	/**
	 * The cookie domain that will be used.
	 */
	@SuppressWarnings("unchecked")
	public T domain(String value) {
		Object oldValue = this.domain;
		this.domain = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("domain", oldValue, value);
		return (T) this;
	}

	/**
	 * Set Cookie httpOnly attribute.
	 */
	@ModelNodeBinding(detypedName = "http-only")
	public Boolean httpOnly() {
		return this.httpOnly;
	}

	/**
	 * Set Cookie httpOnly attribute.
	 */
	@SuppressWarnings("unchecked")
	public T httpOnly(Boolean value) {
		Object oldValue = this.httpOnly;
		this.httpOnly = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("httpOnly", oldValue, value);
		return (T) this;
	}

	/**
	 * Cookie path.
	 */
	@ModelNodeBinding(detypedName = "path")
	public String path() {
		return this.path;
	}

	/**
	 * Cookie path.
	 */
	@SuppressWarnings("unchecked")
	public T path(String value) {
		Object oldValue = this.path;
		this.path = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("path", oldValue, value);
		return (T) this;
	}

	/**
	 * Set Cookie secure attribute.
	 */
	@ModelNodeBinding(detypedName = "secure")
	public Boolean secure() {
		return this.secure;
	}

	/**
	 * Set Cookie secure attribute.
	 */
	@SuppressWarnings("unchecked")
	public T secure(Boolean value) {
		Object oldValue = this.secure;
		this.secure = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("secure", oldValue, value);
		return (T) this;
	}
}