/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.modcluster.mod_cluster_config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider.CustomLoadMetric;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider.CustomLoadMetricConsumer;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider.CustomLoadMetricSupplier;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider.LoadMetric;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider.LoadMetricConsumer;
import org.wildfly.swarm.config.modcluster.mod_cluster_config.dynamic_load_provider.LoadMetricSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/subsystem=modcluster/mod-cluster-config=configuration/dynamic-load-provider=configuration")
@ResourceType(value="dynamic-load-provider")
@Implicit
public class ConfigurationDynamicLoadProvider<T extends ConfigurationDynamicLoadProvider<T>> {
    private String key = "configuration";
    private PropertyChangeSupport pcs;
    private ConfigurationDynamicLoadProviderResources subresources = new ConfigurationDynamicLoadProviderResources();
    private Integer decay;
    private Integer history;

    public ConfigurationDynamicLoadProvider() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public ConfigurationDynamicLoadProviderResources subresources() {
        return this.subresources;
    }

    public T loadMetrics(List<LoadMetric> value) {
        this.subresources.loadMetrics = value;
        return (T)this;
    }

    public T loadMetric(LoadMetric value) {
        this.subresources.loadMetrics.add(value);
        return (T)this;
    }

    public T loadMetric(String childKey, LoadMetricConsumer consumer) {
        LoadMetric child = new LoadMetric(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.loadMetric(child);
        return (T)this;
    }

    public T loadMetric(String childKey) {
        this.loadMetric(childKey, null);
        return (T)this;
    }

    public T loadMetric(LoadMetricSupplier supplier) {
        this.loadMetric(supplier.get());
        return (T)this;
    }

    public T customLoadMetrics(List<CustomLoadMetric> value) {
        this.subresources.customLoadMetrics = value;
        return (T)this;
    }

    public T customLoadMetric(CustomLoadMetric value) {
        this.subresources.customLoadMetrics.add(value);
        return (T)this;
    }

    public T customLoadMetric(String childKey, CustomLoadMetricConsumer consumer) {
        CustomLoadMetric child = new CustomLoadMetric(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.customLoadMetric(child);
        return (T)this;
    }

    public T customLoadMetric(String childKey) {
        this.customLoadMetric(childKey, null);
        return (T)this;
    }

    public T customLoadMetric(CustomLoadMetricSupplier supplier) {
        this.customLoadMetric(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="decay")
    public Integer decay() {
        return this.decay;
    }

    public T decay(Integer value) {
        Integer oldValue = this.decay;
        this.decay = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("decay", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="history")
    public Integer history() {
        return this.history;
    }

    public T history(Integer value) {
        Integer oldValue = this.history;
        this.history = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("history", oldValue, value);
        }
        return (T)this;
    }

    public static class ConfigurationDynamicLoadProviderResources {
        private List<LoadMetric> loadMetrics = new ArrayList<LoadMetric>();
        private List<CustomLoadMetric> customLoadMetrics = new ArrayList<CustomLoadMetric>();

        @Subresource
        public List<LoadMetric> loadMetrics() {
            return this.loadMetrics;
        }

        public LoadMetric loadMetric(String key) {
            return this.loadMetrics.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public List<CustomLoadMetric> customLoadMetrics() {
            return this.customLoadMetrics;
        }

        public CustomLoadMetric customLoadMetric(String key) {
            return this.customLoadMetrics.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

