/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.singleton;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.singleton.singleton_policy.RandomElectionPolicy;
import org.wildfly.swarm.config.singleton.singleton_policy.RandomElectionPolicyConsumer;
import org.wildfly.swarm.config.singleton.singleton_policy.RandomElectionPolicySupplier;
import org.wildfly.swarm.config.singleton.singleton_policy.SimpleElectionPolicy;
import org.wildfly.swarm.config.singleton.singleton_policy.SimpleElectionPolicyConsumer;
import org.wildfly.swarm.config.singleton.singleton_policy.SimpleElectionPolicySupplier;

@Address(value="/subsystem=singleton/singleton-policy=*")
@ResourceType(value="singleton-policy")
public class SingletonPolicy<T extends SingletonPolicy<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private SingletonPolicyResources subresources = new SingletonPolicyResources();
    private String cache;
    private String cacheContainer;
    private Integer quorum;

    public SingletonPolicy(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public SingletonPolicyResources subresources() {
        return this.subresources;
    }

    public T randomElectionPolicy(RandomElectionPolicy value) {
        this.subresources.randomElectionPolicy = value;
        return (T)this;
    }

    public T randomElectionPolicy(RandomElectionPolicyConsumer consumer) {
        RandomElectionPolicy child = new RandomElectionPolicy();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.randomElectionPolicy = child;
        return (T)this;
    }

    public T randomElectionPolicy() {
        RandomElectionPolicy child = new RandomElectionPolicy();
        this.subresources.randomElectionPolicy = child;
        return (T)this;
    }

    public T randomElectionPolicy(RandomElectionPolicySupplier supplier) {
        this.subresources.randomElectionPolicy = supplier.get();
        return (T)this;
    }

    public T simpleElectionPolicy(SimpleElectionPolicy value) {
        this.subresources.simpleElectionPolicy = value;
        return (T)this;
    }

    public T simpleElectionPolicy(SimpleElectionPolicyConsumer consumer) {
        SimpleElectionPolicy child = new SimpleElectionPolicy();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.simpleElectionPolicy = child;
        return (T)this;
    }

    public T simpleElectionPolicy() {
        SimpleElectionPolicy child = new SimpleElectionPolicy();
        this.subresources.simpleElectionPolicy = child;
        return (T)this;
    }

    public T simpleElectionPolicy(SimpleElectionPolicySupplier supplier) {
        this.subresources.simpleElectionPolicy = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cache")
    public String cache() {
        return this.cache;
    }

    public T cache(String value) {
        String oldValue = this.cache;
        this.cache = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cache", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cache-container")
    public String cacheContainer() {
        return this.cacheContainer;
    }

    public T cacheContainer(String value) {
        String oldValue = this.cacheContainer;
        this.cacheContainer = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cacheContainer", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="quorum")
    public Integer quorum() {
        return this.quorum;
    }

    public T quorum(Integer value) {
        Integer oldValue = this.quorum;
        this.quorum = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("quorum", oldValue, value);
        }
        return (T)this;
    }

    public static class SingletonPolicyResources {
        private RandomElectionPolicy randomElectionPolicy;
        private SimpleElectionPolicy simpleElectionPolicy;

        @Subresource
        public RandomElectionPolicy randomElectionPolicy() {
            return this.randomElectionPolicy;
        }

        @Subresource
        public SimpleElectionPolicy simpleElectionPolicy() {
            return this.simpleElectionPolicy;
        }
    }
}

