/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.webservices;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.webservices.Handler;
import org.wildfly.swarm.config.webservices.HandlerConsumer;
import org.wildfly.swarm.config.webservices.HandlerSupplier;

@Addresses(value={"/subsystem=webservices/client-config=*/post-handler-chain=*", "/subsystem=webservices/endpoint-config=*/post-handler-chain=*"})
@ResourceType(value="post-handler-chain")
public class PostHandlerChain<T extends PostHandlerChain<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private PostHandlerChainResources subresources = new PostHandlerChainResources();
    private String protocolBindings;

    public PostHandlerChain(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public PostHandlerChainResources subresources() {
        return this.subresources;
    }

    public T handlers(List<Handler> value) {
        this.subresources.handlers = value;
        return (T)this;
    }

    public T handler(Handler value) {
        this.subresources.handlers.add(value);
        return (T)this;
    }

    public T handler(String childKey, HandlerConsumer consumer) {
        Handler child = new Handler(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.handler(child);
        return (T)this;
    }

    public T handler(String childKey) {
        this.handler(childKey, null);
        return (T)this;
    }

    public T handler(HandlerSupplier supplier) {
        this.handler(supplier.get());
        return (T)this;
    }

    @ModelNodeBinding(detypedName="protocol-bindings")
    public String protocolBindings() {
        return this.protocolBindings;
    }

    public T protocolBindings(String value) {
        String oldValue = this.protocolBindings;
        this.protocolBindings = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("protocolBindings", oldValue, value);
        }
        return (T)this;
    }

    public static class PostHandlerChainResources {
        private List<Handler> handlers = new ArrayList<Handler>();

        @Subresource
        public List<Handler> handlers() {
            return this.handlers;
        }

        public Handler handler(String key) {
            return this.handlers.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }
    }
}

