package org.wildfly.swarm.config;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Implicit;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.modcluster.ConfigurationModClusterConfig;
import org.wildfly.swarm.config.modcluster.ConfigurationModClusterConfigConsumer;
import org.wildfly.swarm.config.modcluster.ConfigurationModClusterConfigSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * The configuration of the modcluster subsystem.
 */
@Address("/subsystem=modcluster")
@ResourceType("subsystem")
@Implicit
public class Modcluster<T extends Modcluster<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private ModclusterResources subresources = new ModclusterResources();

	public Modcluster() {
		this.key = "modcluster";
		this.pcs = new PropertyChangeSupport(this);
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public ModclusterResources subresources() {
		return this.subresources;
	}

	/**
	 * The common modcluster configuration.
	 */
	@SuppressWarnings("unchecked")
	public T configurationModClusterConfig(ConfigurationModClusterConfig value) {
		this.subresources.configurationModClusterConfig = value;
		return (T) this;
	}

	/**
	 * The common modcluster configuration.
	 */
	@SuppressWarnings("unchecked")
	public T configurationModClusterConfig(
			ConfigurationModClusterConfigConsumer consumer) {
		ConfigurationModClusterConfig<? extends ConfigurationModClusterConfig> child = new ConfigurationModClusterConfig<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.configurationModClusterConfig = child;
		return (T) this;
	}

	/**
	 * The common modcluster configuration.
	 */
	@SuppressWarnings("unchecked")
	public T configurationModClusterConfig() {
		ConfigurationModClusterConfig<? extends ConfigurationModClusterConfig> child = new ConfigurationModClusterConfig<>();
		this.subresources.configurationModClusterConfig = child;
		return (T) this;
	}

	/**
	 * The common modcluster configuration.
	 */
	@SuppressWarnings("unchecked")
	public T configurationModClusterConfig(
			ConfigurationModClusterConfigSupplier supplier) {
		this.subresources.configurationModClusterConfig = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for Modcluster
	 */
	public static class ModclusterResources {
		private ConfigurationModClusterConfig configurationModClusterConfig;

		/**
		 * The common modcluster configuration.
		 */
		@Subresource
		public ConfigurationModClusterConfig configurationModClusterConfig() {
			return this.configurationModClusterConfig;
		}
	}
}