package org.wildfly.swarm.config;

import org.wildfly.swarm.config.Naming;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface NamingConsumer<T extends Naming<T>> {

	/**
	 * Configure a pre-constructed instance of Naming resource
	 * 
	 * @parameter Instance of Naming to configure
	 * @return nothing
	 */
	void accept(T value);

	default NamingConsumer<T> andThen(NamingConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}