package org.wildfly.swarm.config.ejb3;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.List;
import java.util.Arrays;
/**
 * A SFSB cache
 */
@Address("/subsystem=ejb3/cache=*")
@ResourceType("cache")
public class Cache<T extends Cache<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private List<String> aliases;
	private String passivationStore;

	public Cache(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The aliases by which this cache may also be referenced
	 */
	@ModelNodeBinding(detypedName = "aliases")
	public List<String> aliases() {
		return this.aliases;
	}

	/**
	 * The aliases by which this cache may also be referenced
	 */
	@SuppressWarnings("unchecked")
	public T aliases(List<String> value) {
		Object oldValue = this.aliases;
		this.aliases = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("aliases", oldValue, value);
		return (T) this;
	}

	/**
	 * The aliases by which this cache may also be referenced
	 */
	@SuppressWarnings("unchecked")
	public T alias(String value) {
		if (this.aliases == null) {
			this.aliases = new java.util.ArrayList<>();
		}
		this.aliases.add(value);
		return (T) this;
	}

	/**
	 * The aliases by which this cache may also be referenced
	 */
	@SuppressWarnings("unchecked")
	public T aliases(String... args) {
		aliases(Arrays.asList(args));
		return (T) this;
	}

	/**
	 * The passivation store used by this cache
	 */
	@ModelNodeBinding(detypedName = "passivation-store")
	public String passivationStore() {
		return this.passivationStore;
	}

	/**
	 * The passivation store used by this cache
	 */
	@SuppressWarnings("unchecked")
	public T passivationStore(String value) {
		Object oldValue = this.passivationStore;
		this.passivationStore = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("passivationStore", oldValue, value);
		return (T) this;
	}
}