package org.wildfly.swarm.config.infinispan.cache_container;

import org.wildfly.swarm.config.infinispan.cache_container.RemoteStore;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface RemoteStoreConsumer<T extends RemoteStore<T>> {

	/**
	 * Configure a pre-constructed instance of RemoteStore resource
	 * 
	 * @parameter Instance of RemoteStore to configure
	 * @return nothing
	 */
	void accept(T value);

	default RemoteStoreConsumer<T> andThen(RemoteStoreConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}