package org.wildfly.swarm.config.jgroups;

import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * A protocol property with name and value.
 */
@Addresses({"/subsystem=jgroups/stack=*/protocol=*/property=*",
		"/subsystem=jgroups/stack=*/transport=*/property=*",
		"/subsystem=jgroups/stack=*/relay=relay.RELAY2/property=*",
		"/subsystem=jgroups/channel=*/fork=*/protocol=*/property=*"})
@ResourceType("property")
public class Property<T extends Property<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String value;

	public Property(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * The value of a protocol property.
	 */
	@ModelNodeBinding(detypedName = "value")
	public String value() {
		return this.value;
	}

	/**
	 * The value of a protocol property.
	 */
	@SuppressWarnings("unchecked")
	public T value(String value) {
		Object oldValue = this.value;
		this.value = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("value", oldValue, value);
		return (T) this;
	}
}