package org.wildfly.swarm.config.mail;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.mail.mail_session.CustomConsumer;
import org.wildfly.swarm.config.mail.mail_session.CustomSupplier;
import org.wildfly.swarm.config.mail.mail_session.Custom;
import org.wildfly.swarm.config.mail.mail_session.POP3Server;
import org.wildfly.swarm.config.mail.mail_session.POP3ServerConsumer;
import org.wildfly.swarm.config.mail.mail_session.POP3ServerSupplier;
import org.wildfly.swarm.config.mail.mail_session.SMTPServer;
import org.wildfly.swarm.config.mail.mail_session.SMTPServerConsumer;
import org.wildfly.swarm.config.mail.mail_session.SMTPServerSupplier;
import org.wildfly.swarm.config.mail.mail_session.IMAPServer;
import org.wildfly.swarm.config.mail.mail_session.IMAPServerConsumer;
import org.wildfly.swarm.config.mail.mail_session.IMAPServerSupplier;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
/**
 * Mail session definition
 */
@Address("/subsystem=mail/mail-session=*")
@ResourceType("mail-session")
public class MailSession<T extends MailSession<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private MailSessionResources subresources = new MailSessionResources();
	private Boolean debug;
	private String from;
	private String jndiName;

	public MailSession(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	public MailSessionResources subresources() {
		return this.subresources;
	}

	/**
	 * Add all Custom objects to this subresource
	 * 
	 * @return this
	 * @param value
	 *            List of Custom objects.
	 */
	@SuppressWarnings("unchecked")
	public T customs(List<Custom> value) {
		this.subresources.customs = value;
		return (T) this;
	}

	/**
	 * Add the Custom object to the list of subresources
	 * 
	 * @param value
	 *            The Custom to add
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T custom(Custom value) {
		this.subresources.customs.add(value);
		return (T) this;
	}

	/**
	 * Create and configure a Custom object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Custom resource
	 * @param config
	 *            The CustomConsumer to use
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T custom(String childKey, CustomConsumer consumer) {
		Custom<? extends Custom> child = new Custom<>(childKey);
		if (consumer != null) {
			consumer.accept(child);
		}
		custom(child);
		return (T) this;
	}

	/**
	 * Create and configure a Custom object to the list of subresources
	 * 
	 * @param key
	 *            The key for the Custom resource
	 * @return this
	 */
	@SuppressWarnings("unchecked")
	public T custom(String childKey) {
		custom(childKey, null);
		return (T) this;
	}

	/**
	 * Install a supplied Custom object to the list of subresources
	 */
	@SuppressWarnings("unchecked")
	public T custom(CustomSupplier supplier) {
		custom(supplier.get());
		return (T) this;
	}

	/**
	 * Mail session server
	 */
	@SuppressWarnings("unchecked")
	public T pop3Server(POP3Server value) {
		this.subresources.pop3Server = value;
		return (T) this;
	}

	/**
	 * Mail session server
	 */
	@SuppressWarnings("unchecked")
	public T pop3Server(POP3ServerConsumer consumer) {
		POP3Server<? extends POP3Server> child = new POP3Server<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.pop3Server = child;
		return (T) this;
	}

	/**
	 * Mail session server
	 */
	@SuppressWarnings("unchecked")
	public T pop3Server() {
		POP3Server<? extends POP3Server> child = new POP3Server<>();
		this.subresources.pop3Server = child;
		return (T) this;
	}

	/**
	 * Mail session server
	 */
	@SuppressWarnings("unchecked")
	public T pop3Server(POP3ServerSupplier supplier) {
		this.subresources.pop3Server = supplier.get();
		return (T) this;
	}

	/**
	 * Mail session server
	 */
	@SuppressWarnings("unchecked")
	public T smtpServer(SMTPServer value) {
		this.subresources.smtpServer = value;
		return (T) this;
	}

	/**
	 * Mail session server
	 */
	@SuppressWarnings("unchecked")
	public T smtpServer(SMTPServerConsumer consumer) {
		SMTPServer<? extends SMTPServer> child = new SMTPServer<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.smtpServer = child;
		return (T) this;
	}

	/**
	 * Mail session server
	 */
	@SuppressWarnings("unchecked")
	public T smtpServer() {
		SMTPServer<? extends SMTPServer> child = new SMTPServer<>();
		this.subresources.smtpServer = child;
		return (T) this;
	}

	/**
	 * Mail session server
	 */
	@SuppressWarnings("unchecked")
	public T smtpServer(SMTPServerSupplier supplier) {
		this.subresources.smtpServer = supplier.get();
		return (T) this;
	}

	/**
	 * Mail session server
	 */
	@SuppressWarnings("unchecked")
	public T imapServer(IMAPServer value) {
		this.subresources.imapServer = value;
		return (T) this;
	}

	/**
	 * Mail session server
	 */
	@SuppressWarnings("unchecked")
	public T imapServer(IMAPServerConsumer consumer) {
		IMAPServer<? extends IMAPServer> child = new IMAPServer<>();
		if (consumer != null) {
			consumer.accept(child);
		}
		this.subresources.imapServer = child;
		return (T) this;
	}

	/**
	 * Mail session server
	 */
	@SuppressWarnings("unchecked")
	public T imapServer() {
		IMAPServer<? extends IMAPServer> child = new IMAPServer<>();
		this.subresources.imapServer = child;
		return (T) this;
	}

	/**
	 * Mail session server
	 */
	@SuppressWarnings("unchecked")
	public T imapServer(IMAPServerSupplier supplier) {
		this.subresources.imapServer = supplier.get();
		return (T) this;
	}

	/**
	 * Child mutators for MailSession
	 */
	public static class MailSessionResources {
		/**
		 * Mail session server
		 */
		private List<Custom> customs = new java.util.ArrayList<>();
		private POP3Server pop3Server;
		private SMTPServer smtpServer;
		private IMAPServer imapServer;

		/**
		 * Get the list of Custom resources
		 * 
		 * @return the list of resources
		 */
		@Subresource
		public List<Custom> customs() {
			return this.customs;
		}

		public Custom custom(String key) {
			return this.customs.stream().filter(e -> e.getKey().equals(key))
					.findFirst().orElse(null);
		}
		/**
		 * Mail session server
		 */
		@Subresource
		public POP3Server pop3Server() {
			return this.pop3Server;
		}

		/**
		 * Mail session server
		 */
		@Subresource
		public SMTPServer smtpServer() {
			return this.smtpServer;
		}

		/**
		 * Mail session server
		 */
		@Subresource
		public IMAPServer imapServer() {
			return this.imapServer;
		}
	}

	/**
	 * Enables JavaMail debugging
	 */
	@ModelNodeBinding(detypedName = "debug")
	public Boolean debug() {
		return this.debug;
	}

	/**
	 * Enables JavaMail debugging
	 */
	@SuppressWarnings("unchecked")
	public T debug(Boolean value) {
		Object oldValue = this.debug;
		this.debug = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("debug", oldValue, value);
		return (T) this;
	}

	/**
	 * From address that is used as default from, if not set when sending
	 */
	@ModelNodeBinding(detypedName = "from")
	public String from() {
		return this.from;
	}

	/**
	 * From address that is used as default from, if not set when sending
	 */
	@SuppressWarnings("unchecked")
	public T from(String value) {
		Object oldValue = this.from;
		this.from = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("from", oldValue, value);
		return (T) this;
	}

	/**
	 * JNDI name to where mail session should be bound
	 */
	@ModelNodeBinding(detypedName = "jndi-name")
	public String jndiName() {
		return this.jndiName;
	}

	/**
	 * JNDI name to where mail session should be bound
	 */
	@SuppressWarnings("unchecked")
	public T jndiName(String value) {
		Object oldValue = this.jndiName;
		this.jndiName = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("jndiName", oldValue, value);
		return (T) this;
	}
}