package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.management.security_realm.LdapAuthentication;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface LdapAuthenticationConsumer<T extends LdapAuthentication<T>> {

	/**
	 * Configure a pre-constructed instance of LdapAuthentication resource
	 * 
	 * @parameter Instance of LdapAuthentication to configure
	 * @return nothing
	 */
	void accept(T value);

	default LdapAuthenticationConsumer<T> andThen(
			LdapAuthenticationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}