package org.wildfly.swarm.config.management.security_realm;

import org.wildfly.swarm.config.management.security_realm.SecretServerIdentity;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface SecretServerIdentityConsumer<T extends SecretServerIdentity<T>> {

	/**
	 * Configure a pre-constructed instance of SecretServerIdentity resource
	 * 
	 * @parameter Instance of SecretServerIdentity to configure
	 * @return nothing
	 */
	void accept(T value);

	default SecretServerIdentityConsumer<T> andThen(
			SecretServerIdentityConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}