package org.wildfly.swarm.config.messaging.activemq.server;

import org.wildfly.swarm.config.messaging.activemq.server.PooledConnectionFactory;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface PooledConnectionFactoryConsumer<T extends PooledConnectionFactory<T>> {

	/**
	 * Configure a pre-constructed instance of PooledConnectionFactory resource
	 * 
	 * @parameter Instance of PooledConnectionFactory to configure
	 * @return nothing
	 */
	void accept(T value);

	default PooledConnectionFactoryConsumer<T> andThen(
			PooledConnectionFactoryConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}