package org.wildfly.swarm.config.security.security_domain.audit;

import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ResourceType;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import java.util.Map;
/**
 * List of modules that map principal, role, and credential information
 */
@Address("/subsystem=security/security-domain=*/audit=classic/provider-module=*")
@ResourceType("provider-module")
public class ProviderModule<T extends ProviderModule<T>> {

	private String key;
	private PropertyChangeSupport pcs;
	private String code;
	private Map moduleOptions;

	public ProviderModule(String key) {
		this.key = key;
	}

	public String getKey() {
		return this.key;
	}

	/**
	 * Adds a property change listener
	 */
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		if (null == this.pcs)
			this.pcs = new PropertyChangeSupport(this);
		this.pcs.addPropertyChangeListener(listener);
	}

	/**
	 * Removes a property change listener
	 */
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		if (this.pcs != null)
			this.pcs.removePropertyChangeListener(listener);
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@ModelNodeBinding(detypedName = "code")
	public String code() {
		return this.code;
	}

	/**
	 * Class name of the module to be instantiated.
	 */
	@SuppressWarnings("unchecked")
	public T code(String value) {
		Object oldValue = this.code;
		this.code = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("code", oldValue, value);
		return (T) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@ModelNodeBinding(detypedName = "module-options")
	public Map moduleOptions() {
		return this.moduleOptions;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@SuppressWarnings("unchecked")
	public T moduleOptions(Map value) {
		Object oldValue = this.moduleOptions;
		this.moduleOptions = value;
		if (this.pcs != null)
			this.pcs.firePropertyChange("moduleOptions", oldValue, value);
		return (T) this;
	}

	/**
	 * List of module options containing a name/value pair.
	 */
	@SuppressWarnings("unchecked")
	public T moduleOption(String key, Object value) {
		if (this.moduleOptions == null) {
			this.moduleOptions = new java.util.HashMap<>();
		}
		this.moduleOptions.put(key, value);
		return (T) this;
	}
}