package org.wildfly.swarm.config.singleton.singleton_policy;

import org.wildfly.swarm.config.singleton.singleton_policy.SimpleElectionPolicy;
import java.lang.FunctionalInterface;
@FunctionalInterface
public interface SimpleElectionPolicyConsumer<T extends SimpleElectionPolicy<T>> {

	/**
	 * Configure a pre-constructed instance of SimpleElectionPolicy resource
	 * 
	 * @parameter Instance of SimpleElectionPolicy to configure
	 * @return nothing
	 */
	void accept(T value);

	default SimpleElectionPolicyConsumer<T> andThen(
			SimpleElectionPolicyConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}