/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.wildfly.swarm.config.logging.Level;
import org.wildfly.swarm.config.runtime.Addresses;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Addresses(value={"/subsystem=logging/syslog-handler=*", "/subsystem=logging/logging-profile=*/syslog-handler=*"})
@ResourceType(value="syslog-handler")
public class SyslogHandler<T extends SyslogHandler<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private String appName;
    private Boolean enabled;
    private Facility facility;
    private String hostname;
    private Level level;
    private Integer port;
    private String serverAddress;
    private SyslogFormat syslogFormat;

    public SyslogHandler(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="app-name")
    public String appName() {
        return this.appName;
    }

    public T appName(String value) {
        String oldValue = this.appName;
        this.appName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("appName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="enabled")
    public Boolean enabled() {
        return this.enabled;
    }

    public T enabled(Boolean value) {
        Boolean oldValue = this.enabled;
        this.enabled = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("enabled", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="facility")
    public Facility facility() {
        return this.facility;
    }

    public T facility(Facility value) {
        Facility oldValue = this.facility;
        this.facility = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("facility", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="hostname")
    public String hostname() {
        return this.hostname;
    }

    public T hostname(String value) {
        String oldValue = this.hostname;
        this.hostname = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("hostname", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="level")
    public Level level() {
        return this.level;
    }

    public T level(Level value) {
        Level oldValue = this.level;
        this.level = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("level", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="port")
    public Integer port() {
        return this.port;
    }

    public T port(Integer value) {
        Integer oldValue = this.port;
        this.port = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("port", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-address")
    public String serverAddress() {
        return this.serverAddress;
    }

    public T serverAddress(String value) {
        String oldValue = this.serverAddress;
        this.serverAddress = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("serverAddress", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="syslog-format")
    public SyslogFormat syslogFormat() {
        return this.syslogFormat;
    }

    public T syslogFormat(SyslogFormat value) {
        SyslogFormat oldValue = this.syslogFormat;
        this.syslogFormat = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("syslogFormat", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    public static enum SyslogFormat {
        RFC5424("RFC5424"),
        RFC3164("RFC3164");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private SyslogFormat(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }

    public static enum Facility {
        KERNEL("kernel"),
        USER_LEVEL("user-level"),
        MAIL_SYSTEM("mail-system"),
        SYSTEM_DAEMONS("system-daemons"),
        SECURITY("security"),
        SYSLOGD("syslogd"),
        LINE_PRINTER("line-printer"),
        NETWORK_NEWS("network-news"),
        UUCP("uucp"),
        CLOCK_DAEMON("clock-daemon"),
        SECURITY2("security2"),
        FTP_DAEMON("ftp-daemon"),
        NTP("ntp"),
        LOG_AUDIT("log-audit"),
        LOG_ALERT("log-alert"),
        CLOCK_DAEMON2("clock-daemon2"),
        LOCAL_USE_0("local-use-0"),
        LOCAL_USE_1("local-use-1"),
        LOCAL_USE_2("local-use-2"),
        LOCAL_USE_3("local-use-3"),
        LOCAL_USE_4("local-use-4"),
        LOCAL_USE_5("local-use-5"),
        LOCAL_USE_6("local-use-6"),
        LOCAL_USE_7("local-use-7");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private Facility(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

