/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.mail;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.wildfly.swarm.config.mail.mail_session.Custom;
import org.wildfly.swarm.config.mail.mail_session.CustomConsumer;
import org.wildfly.swarm.config.mail.mail_session.CustomSupplier;
import org.wildfly.swarm.config.mail.mail_session.IMAPServer;
import org.wildfly.swarm.config.mail.mail_session.IMAPServerConsumer;
import org.wildfly.swarm.config.mail.mail_session.IMAPServerSupplier;
import org.wildfly.swarm.config.mail.mail_session.POP3Server;
import org.wildfly.swarm.config.mail.mail_session.POP3ServerConsumer;
import org.wildfly.swarm.config.mail.mail_session.POP3ServerSupplier;
import org.wildfly.swarm.config.mail.mail_session.SMTPServer;
import org.wildfly.swarm.config.mail.mail_session.SMTPServerConsumer;
import org.wildfly.swarm.config.mail.mail_session.SMTPServerSupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.Subresource;

@Address(value="/subsystem=mail/mail-session=*")
@ResourceType(value="mail-session")
public class MailSession<T extends MailSession<T>> {
    private String key;
    private PropertyChangeSupport pcs;
    private MailSessionResources subresources = new MailSessionResources();
    private Boolean debug;
    private String from;
    private String jndiName;

    public MailSession(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public MailSessionResources subresources() {
        return this.subresources;
    }

    public T customs(List<Custom> value) {
        this.subresources.customs = value;
        return (T)this;
    }

    public T custom(Custom value) {
        this.subresources.customs.add(value);
        return (T)this;
    }

    public T custom(String childKey, CustomConsumer consumer) {
        Custom child = new Custom(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.custom(child);
        return (T)this;
    }

    public T custom(String childKey) {
        this.custom(childKey, null);
        return (T)this;
    }

    public T custom(CustomSupplier supplier) {
        this.custom(supplier.get());
        return (T)this;
    }

    public T pop3Server(POP3Server value) {
        this.subresources.pop3Server = value;
        return (T)this;
    }

    public T pop3Server(POP3ServerConsumer consumer) {
        POP3Server child = new POP3Server();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.pop3Server = child;
        return (T)this;
    }

    public T pop3Server() {
        POP3Server child = new POP3Server();
        this.subresources.pop3Server = child;
        return (T)this;
    }

    public T pop3Server(POP3ServerSupplier supplier) {
        this.subresources.pop3Server = supplier.get();
        return (T)this;
    }

    public T smtpServer(SMTPServer value) {
        this.subresources.smtpServer = value;
        return (T)this;
    }

    public T smtpServer(SMTPServerConsumer consumer) {
        SMTPServer child = new SMTPServer();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.smtpServer = child;
        return (T)this;
    }

    public T smtpServer() {
        SMTPServer child = new SMTPServer();
        this.subresources.smtpServer = child;
        return (T)this;
    }

    public T smtpServer(SMTPServerSupplier supplier) {
        this.subresources.smtpServer = supplier.get();
        return (T)this;
    }

    public T imapServer(IMAPServer value) {
        this.subresources.imapServer = value;
        return (T)this;
    }

    public T imapServer(IMAPServerConsumer consumer) {
        IMAPServer child = new IMAPServer();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.imapServer = child;
        return (T)this;
    }

    public T imapServer() {
        IMAPServer child = new IMAPServer();
        this.subresources.imapServer = child;
        return (T)this;
    }

    public T imapServer(IMAPServerSupplier supplier) {
        this.subresources.imapServer = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="debug")
    public Boolean debug() {
        return this.debug;
    }

    public T debug(Boolean value) {
        Boolean oldValue = this.debug;
        this.debug = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("debug", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="from")
    public String from() {
        return this.from;
    }

    public T from(String value) {
        String oldValue = this.from;
        this.from = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("from", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="jndi-name")
    public String jndiName() {
        return this.jndiName;
    }

    public T jndiName(String value) {
        String oldValue = this.jndiName;
        this.jndiName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("jndiName", oldValue, value);
        }
        return (T)this;
    }

    public static class MailSessionResources {
        private List<Custom> customs = new ArrayList<Custom>();
        private POP3Server pop3Server;
        private SMTPServer smtpServer;
        private IMAPServer imapServer;

        @Subresource
        public List<Custom> customs() {
            return this.customs;
        }

        public Custom custom(String key) {
            return this.customs.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public POP3Server pop3Server() {
            return this.pop3Server;
        }

        @Subresource
        public SMTPServer smtpServer() {
            return this.smtpServer;
        }

        @Subresource
        public IMAPServer imapServer() {
            return this.imapServer;
        }
    }
}

